/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.Accountant;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.initialization.qual.Initialized;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.NonNull;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.dataflow.qual.SideEffectFree;

public class AllocationOutcomeDetails {
    @UnknownKeyFor @NonNull @Initialized Deque<@UnknownKeyFor @NonNull @Initialized Entry> allocEntries = new ArrayDeque<Entry>();

    AllocationOutcomeDetails() {
    }

    void pushEntry(@UnknownKeyFor @NonNull @Initialized Accountant accountant, @UnknownKeyFor @NonNull @Initialized long totalUsedBeforeAllocation, @UnknownKeyFor @NonNull @Initialized long requestedSize, @UnknownKeyFor @NonNull @Initialized long allocatedSize, @UnknownKeyFor @NonNull @Initialized boolean allocationFailed) {
        Entry top = this.allocEntries.peekLast();
        if (top != null && top.allocationFailed) {
            return;
        }
        this.allocEntries.addLast(new Entry(accountant, totalUsedBeforeAllocation, requestedSize, allocatedSize, allocationFailed));
    }

    public @Nullable @UnknownKeyFor @Initialized BufferAllocator getFailedAllocator() {
        Entry top = this.allocEntries.peekLast();
        if (top != null && top.allocationFailed && top.accountant instanceof BufferAllocator) {
            return (BufferAllocator)((Object)top.accountant);
        }
        return null;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Allocation outcome details:\n");
        this.allocEntries.forEach(sb::append);
        return sb.toString();
    }

    public static class Entry {
        private final @UnknownKeyFor @NonNull @Initialized Accountant accountant;
        private final @UnknownKeyFor @NonNull @Initialized long limit;
        private final @UnknownKeyFor @NonNull @Initialized long used;
        private final @UnknownKeyFor @NonNull @Initialized long requestedSize;
        private final @UnknownKeyFor @NonNull @Initialized long allocatedSize;
        private final @UnknownKeyFor @NonNull @Initialized boolean allocationFailed;

        Entry(@UnknownKeyFor @NonNull @Initialized Accountant accountant, @UnknownKeyFor @NonNull @Initialized long totalUsedBeforeAllocation, @UnknownKeyFor @NonNull @Initialized long requestedSize, @UnknownKeyFor @NonNull @Initialized long allocatedSize, @UnknownKeyFor @NonNull @Initialized boolean allocationFailed) {
            this.accountant = accountant;
            this.limit = accountant.getLimit();
            this.used = totalUsedBeforeAllocation;
            this.requestedSize = requestedSize;
            this.allocatedSize = allocatedSize;
            this.allocationFailed = allocationFailed;
        }

        public @UnknownKeyFor @NonNull @Initialized Accountant getAccountant() {
            return this.accountant;
        }

        public @UnknownKeyFor @NonNull @Initialized long getLimit() {
            return this.limit;
        }

        public @UnknownKeyFor @NonNull @Initialized long getUsed() {
            return this.used;
        }

        public @UnknownKeyFor @NonNull @Initialized long getRequestedSize() {
            return this.requestedSize;
        }

        public @UnknownKeyFor @NonNull @Initialized long getAllocatedSize() {
            return this.allocatedSize;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isAllocationFailed() {
            return this.allocationFailed;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "allocator[" + this.accountant.getName() + "]" + (" reservation: " + this.accountant.getInitReservation()) + (" limit: " + this.limit) + (" used: " + this.used) + (" requestedSize: " + this.requestedSize) + (" allocatedSize: " + this.allocatedSize) + (" localAllocationStatus: " + (this.allocationFailed ? "fail" : "success")) + "\n";
        }
    }
}

