/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.calendar;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcTime;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.accessor.impl.calendar.ArrowFlightJdbcTimeVectorGetter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import org.apache.arrow.driver.jdbc.utils.DateTimeUtils;

public class ArrowFlightJdbcTimeVectorAccessor
extends ArrowFlightJdbcAccessor {
    private final ArrowFlightJdbcTimeVectorGetter.Getter getter;
    private final TimeUnit timeUnit;
    private final ArrowFlightJdbcTimeVectorGetter.Holder holder = new ArrowFlightJdbcTimeVectorGetter.Holder();

    public ArrowFlightJdbcTimeVectorAccessor(TimeNanoVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.getter = ArrowFlightJdbcTimeVectorGetter.createGetter(vector);
        this.timeUnit = ArrowFlightJdbcTimeVectorAccessor.getTimeUnitForVector(vector);
    }

    public ArrowFlightJdbcTimeVectorAccessor(TimeMicroVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.getter = ArrowFlightJdbcTimeVectorGetter.createGetter(vector);
        this.timeUnit = ArrowFlightJdbcTimeVectorAccessor.getTimeUnitForVector(vector);
    }

    public ArrowFlightJdbcTimeVectorAccessor(TimeMilliVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.getter = ArrowFlightJdbcTimeVectorGetter.createGetter(vector);
        this.timeUnit = ArrowFlightJdbcTimeVectorAccessor.getTimeUnitForVector(vector);
    }

    public ArrowFlightJdbcTimeVectorAccessor(TimeSecVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.getter = ArrowFlightJdbcTimeVectorGetter.createGetter(vector);
        this.timeUnit = ArrowFlightJdbcTimeVectorAccessor.getTimeUnitForVector(vector);
    }

    @Override
    public Class<?> getObjectClass() {
        return Time.class;
    }

    @Override
    public Object getObject() {
        return this.getTime(null);
    }

    @Override
    public Time getTime(Calendar calendar) {
        this.fillHolder();
        if (this.wasNull) {
            return null;
        }
        long value = this.holder.value;
        long milliseconds = this.timeUnit.toMillis(value);
        return new ArrowFlightJdbcTime(DateTimeUtils.applyCalendarOffset(milliseconds, calendar));
    }

    private void fillHolder() {
        this.getter.get(this.getCurrentRow(), this.holder);
        this.wasNull = this.holder.isSet == 0;
        this.wasNullConsumer.setWasNull(this.wasNull);
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) {
        Time time = this.getTime(calendar);
        if (time == null) {
            return null;
        }
        return new Timestamp(time.getTime());
    }

    protected static TimeUnit getTimeUnitForVector(ValueVector vector) {
        if (vector instanceof TimeNanoVector) {
            return TimeUnit.NANOSECONDS;
        }
        if (vector instanceof TimeMicroVector) {
            return TimeUnit.MICROSECONDS;
        }
        if (vector instanceof TimeMilliVector) {
            return TimeUnit.MILLISECONDS;
        }
        if (vector instanceof TimeSecVector) {
            return TimeUnit.SECONDS;
        }
        throw new IllegalArgumentException("Invalid Arrow vector");
    }
}

