/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallHeaders;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallInfo;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallStatus;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightServerMiddleware;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.RequestContext;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.SessionOptionValue;

public class ServerSessionMiddleware
implements FlightServerMiddleware {
    Factory factory;
    boolean existingSession;
    private Session session;
    private String closedSessionId = null;
    public static final String sessionCookieName = "arrow_flight_session_id";
    private final CallHeaders headers;

    private ServerSessionMiddleware(Factory factory, CallHeaders incomingHeaders, Session session) {
        this.factory = factory;
        this.headers = incomingHeaders;
        this.session = session;
        this.existingSession = session != null;
    }

    public boolean hasSession() {
        return this.session != null;
    }

    public synchronized Session getSession() {
        if (this.session == null) {
            this.session = this.factory.createNewSession();
        }
        return this.session;
    }

    public synchronized void closeSession() {
        if (this.session == null) {
            throw CallStatus.NOT_FOUND.withDescription("No session found for the current call.").toRuntimeException();
        }
        this.factory.closeSession(this.session.id);
        this.closedSessionId = this.session.id;
        this.session = null;
    }

    public CallHeaders getCallHeaders() {
        return this.headers;
    }

    @Override
    public void onBeforeSendingHeaders(CallHeaders outgoingHeaders) {
        if (!this.existingSession && this.session != null) {
            outgoingHeaders.insert("set-cookie", "arrow_flight_session_id=" + this.session.id);
        }
        if (this.closedSessionId != null) {
            outgoingHeaders.insert("set-cookie", "arrow_flight_session_id=" + this.closedSessionId + "; Max-Age=0");
        }
    }

    @Override
    public void onCallCompleted(CallStatus status) {
    }

    @Override
    public void onCallErrored(Throwable err) {
    }

    public static class Session {
        public final String id;
        private ConcurrentMap<String, SessionOptionValue> sessionData = new ConcurrentHashMap<String, SessionOptionValue>();

        private Session(String id) {
            this.id = id;
        }

        public SessionOptionValue getSessionOption(String name) {
            return (SessionOptionValue)this.sessionData.get(name);
        }

        public Map<String, SessionOptionValue> getSessionOptions() {
            return Collections.unmodifiableMap(new HashMap<String, SessionOptionValue>(this.sessionData));
        }

        public void setSessionOption(String name, SessionOptionValue value) {
            this.sessionData.put(name, value);
        }

        public void eraseSessionOption(String name) {
            this.sessionData.remove(name);
        }
    }

    public static class Factory
    implements FlightServerMiddleware.Factory<ServerSessionMiddleware> {
        private final ConcurrentMap<String, Session> sessionStore = new ConcurrentHashMap<String, Session>();
        private final Callable<String> idGenerator;

        public Factory(Callable<String> idGenerator) {
            this.idGenerator = idGenerator;
        }

        private synchronized Session createNewSession() {
            String id;
            try {
                id = this.idGenerator.call();
            }
            catch (Exception ignored) {
                throw CallStatus.INTERNAL.withDescription("Session creation error").toRuntimeException();
            }
            Session newSession = new Session(id);
            if (this.sessionStore.putIfAbsent(id, newSession) != null) {
                throw CallStatus.INTERNAL.withDescription("Session creation error").toRuntimeException();
            }
            return newSession;
        }

        private void closeSession(String id) {
            if (this.sessionStore.remove(id) == null) {
                throw CallStatus.NOT_FOUND.withDescription("Session id '" + id + "' not found.").toRuntimeException();
            }
        }

        @Override
        public ServerSessionMiddleware onCallStarted(CallInfo callInfo, CallHeaders incomingHeaders, RequestContext context) {
            String sessionId = null;
            Iterable<String> it = incomingHeaders.getAll("cookie");
            if (it != null) {
                block0: for (String headerValue : it) {
                    String cookie;
                    String[] cookiePair;
                    String[] stringArray = headerValue.split(" ;");
                    int n = stringArray.length;
                    for (int i = 0; i < n && (cookiePair = (cookie = stringArray[i]).split("=")).length == 2; ++i) {
                        if (!ServerSessionMiddleware.sessionCookieName.equals(cookiePair[0]) || cookiePair[1].length() <= 0) continue;
                        sessionId = cookiePair[1];
                        break block0;
                    }
                }
            }
            if (sessionId == null) {
                return new ServerSessionMiddleware(this, incomingHeaders, null);
            }
            Session session = (Session)this.sessionStore.get(sessionId);
            if (session == null) {
                throw CallStatus.NOT_FOUND.withDescription("Invalid arrow_flight_session_id cookie.").toRuntimeException();
            }
            return new ServerSessionMiddleware(this, incomingHeaders, session);
        }
    }
}

