/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.util.HashMap;
import java.util.Map;
import org.apache.arrow.flight.CloseSessionRequest;
import org.apache.arrow.flight.CloseSessionResult;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.FlightServerMiddleware;
import org.apache.arrow.flight.GetSessionOptionsRequest;
import org.apache.arrow.flight.GetSessionOptionsResult;
import org.apache.arrow.flight.ServerSessionMiddleware;
import org.apache.arrow.flight.SessionOptionValue;
import org.apache.arrow.flight.SessionOptionValueFactory;
import org.apache.arrow.flight.SetSessionOptionsRequest;
import org.apache.arrow.flight.SetSessionOptionsResult;
import org.apache.arrow.flight.sql.NoOpFlightSqlProducer;

final class SessionOptionsProducer
extends NoOpFlightSqlProducer {
    private static final SessionOptionValue invalidOptionValue = SessionOptionValueFactory.makeSessionOptionValue((String)"lol_invalid");
    private final FlightServerMiddleware.Key<ServerSessionMiddleware> sessionMiddlewareKey;

    SessionOptionsProducer(FlightServerMiddleware.Key<ServerSessionMiddleware> sessionMiddlewareKey) {
        this.sessionMiddlewareKey = sessionMiddlewareKey;
    }

    public void setSessionOptions(SetSessionOptionsRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<SetSessionOptionsResult> listener) {
        HashMap<String, SetSessionOptionsResult.Error> errors = new HashMap<String, SetSessionOptionsResult.Error>();
        ServerSessionMiddleware middleware = (ServerSessionMiddleware)context.getMiddleware(this.sessionMiddlewareKey);
        ServerSessionMiddleware.Session session = middleware.getSession();
        for (Map.Entry entry : request.getSessionOptions().entrySet()) {
            if (((String)entry.getKey()).equals("lol_invalid")) {
                errors.put((String)entry.getKey(), new SetSessionOptionsResult.Error(SetSessionOptionsResult.ErrorValue.INVALID_NAME));
                continue;
            }
            if (((SessionOptionValue)entry.getValue()).equals(invalidOptionValue)) {
                errors.put((String)entry.getKey(), new SetSessionOptionsResult.Error(SetSessionOptionsResult.ErrorValue.INVALID_VALUE));
                continue;
            }
            if (((SessionOptionValue)entry.getValue()).isEmpty()) {
                session.eraseSessionOption((String)entry.getKey());
                continue;
            }
            session.setSessionOption((String)entry.getKey(), (SessionOptionValue)entry.getValue());
        }
        listener.onNext((Object)new SetSessionOptionsResult(errors));
        listener.onCompleted();
    }

    public void getSessionOptions(GetSessionOptionsRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<GetSessionOptionsResult> listener) {
        ServerSessionMiddleware middleware = (ServerSessionMiddleware)context.getMiddleware(this.sessionMiddlewareKey);
        Map sessionOptions = middleware.getSession().getSessionOptions();
        listener.onNext((Object)new GetSessionOptionsResult(sessionOptions));
        listener.onCompleted();
    }

    public void closeSession(CloseSessionRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<CloseSessionResult> listener) {
        ServerSessionMiddleware middleware = (ServerSessionMiddleware)context.getMiddleware(this.sessionMiddlewareKey);
        try {
            middleware.closeSession();
        }
        catch (FlightRuntimeException fre) {
            listener.onError((Throwable)fre);
            return;
        }
        listener.onNext((Object)new CloseSessionResult(CloseSessionResult.Status.CLOSED));
        listener.onCompleted();
    }
}

