/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import com.google.protobuf.Any;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.SchemaResult;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.integration.tests.FlightSqlScenarioProducer;
import org.apache.arrow.flight.integration.tests.IntegrationAssertions;
import org.apache.arrow.flight.integration.tests.Scenario;
import org.apache.arrow.flight.sql.FlightSqlClient;
import org.apache.arrow.flight.sql.FlightSqlProducer;
import org.apache.arrow.flight.sql.FlightSqlUtils;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.flight.sql.util.TableRef;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Text;

public class FlightSqlScenario
implements Scenario {
    public static final long UPDATE_STATEMENT_EXPECTED_ROWS = 10000L;
    public static final long UPDATE_STATEMENT_WITH_TRANSACTION_EXPECTED_ROWS = 15000L;
    public static final long UPDATE_PREPARED_STATEMENT_EXPECTED_ROWS = 20000L;
    public static final long UPDATE_PREPARED_STATEMENT_WITH_TRANSACTION_EXPECTED_ROWS = 25000L;
    public static final byte[] SAVEPOINT_ID = "savepoint_id".getBytes(StandardCharsets.UTF_8);
    public static final String SAVEPOINT_NAME = "savepoint_name";
    public static final byte[] SUBSTRAIT_PLAN_TEXT = "plan".getBytes(StandardCharsets.UTF_8);
    public static final String SUBSTRAIT_VERSION = "version";
    public static final FlightSqlClient.SubstraitPlan SUBSTRAIT_PLAN = new FlightSqlClient.SubstraitPlan(SUBSTRAIT_PLAN_TEXT, "version");
    public static final byte[] TRANSACTION_ID = "transaction_id".getBytes(StandardCharsets.UTF_8);
    public static final byte[] BULK_INGEST_TRANSACTION_ID = "123".getBytes(StandardCharsets.UTF_8);

    @Override
    public FlightProducer producer(BufferAllocator allocator, Location location) throws Exception {
        return new FlightSqlScenarioProducer(allocator);
    }

    @Override
    public void buildServer(FlightServer.Builder builder) throws Exception {
    }

    @Override
    public void client(BufferAllocator allocator, Location location, FlightClient client) throws Exception {
        try (FlightSqlClient sqlClient = new FlightSqlClient(client);){
            this.validateMetadataRetrieval(sqlClient);
            this.validateStatementExecution(sqlClient);
            this.validatePreparedStatementExecution(allocator, sqlClient);
        }
    }

    private void validateMetadataRetrieval(FlightSqlClient sqlClient) throws Exception {
        CallOption[] options = new CallOption[]{};
        this.validate(FlightSqlProducer.Schemas.GET_CATALOGS_SCHEMA, sqlClient.getCatalogs(options), sqlClient);
        this.validateSchema(FlightSqlProducer.Schemas.GET_CATALOGS_SCHEMA, sqlClient.getCatalogsSchema(options));
        this.validate(FlightSqlProducer.Schemas.GET_SCHEMAS_SCHEMA, sqlClient.getSchemas("catalog", "db_schema_filter_pattern", options), sqlClient);
        this.validateSchema(FlightSqlProducer.Schemas.GET_SCHEMAS_SCHEMA, sqlClient.getSchemasSchema(new CallOption[0]));
        this.validate(FlightSqlProducer.Schemas.GET_TABLES_SCHEMA, sqlClient.getTables("catalog", "db_schema_filter_pattern", "table_filter_pattern", Arrays.asList("table", "view"), true, options), sqlClient);
        this.validateSchema(FlightSqlProducer.Schemas.GET_TABLES_SCHEMA, sqlClient.getTablesSchema(true, options));
        this.validateSchema(FlightSqlProducer.Schemas.GET_TABLES_SCHEMA_NO_SCHEMA, sqlClient.getTablesSchema(false, options));
        this.validate(FlightSqlProducer.Schemas.GET_TABLE_TYPES_SCHEMA, sqlClient.getTableTypes(options), sqlClient);
        this.validateSchema(FlightSqlProducer.Schemas.GET_TABLE_TYPES_SCHEMA, sqlClient.getTableTypesSchema(options));
        this.validate(FlightSqlProducer.Schemas.GET_PRIMARY_KEYS_SCHEMA, sqlClient.getPrimaryKeys(TableRef.of((String)"catalog", (String)"db_schema", (String)"table"), options), sqlClient);
        this.validateSchema(FlightSqlProducer.Schemas.GET_PRIMARY_KEYS_SCHEMA, sqlClient.getPrimaryKeysSchema(options));
        this.validate(FlightSqlProducer.Schemas.GET_EXPORTED_KEYS_SCHEMA, sqlClient.getExportedKeys(TableRef.of((String)"catalog", (String)"db_schema", (String)"table"), options), sqlClient);
        this.validateSchema(FlightSqlProducer.Schemas.GET_EXPORTED_KEYS_SCHEMA, sqlClient.getExportedKeysSchema(options));
        this.validate(FlightSqlProducer.Schemas.GET_IMPORTED_KEYS_SCHEMA, sqlClient.getImportedKeys(TableRef.of((String)"catalog", (String)"db_schema", (String)"table"), options), sqlClient);
        this.validateSchema(FlightSqlProducer.Schemas.GET_IMPORTED_KEYS_SCHEMA, sqlClient.getImportedKeysSchema(options));
        this.validate(FlightSqlProducer.Schemas.GET_CROSS_REFERENCE_SCHEMA, sqlClient.getCrossReference(TableRef.of((String)"pk_catalog", (String)"pk_db_schema", (String)"pk_table"), TableRef.of((String)"fk_catalog", (String)"fk_db_schema", (String)"fk_table"), options), sqlClient);
        this.validateSchema(FlightSqlProducer.Schemas.GET_CROSS_REFERENCE_SCHEMA, sqlClient.getCrossReferenceSchema(options));
        this.validate(FlightSqlProducer.Schemas.GET_TYPE_INFO_SCHEMA, sqlClient.getXdbcTypeInfo(options), sqlClient);
        this.validateSchema(FlightSqlProducer.Schemas.GET_TYPE_INFO_SCHEMA, sqlClient.getXdbcTypeInfoSchema(options));
        FlightInfo sqlInfoFlightInfo = sqlClient.getSqlInfo(new FlightSql.SqlInfo[]{FlightSql.SqlInfo.FLIGHT_SQL_SERVER_NAME, FlightSql.SqlInfo.FLIGHT_SQL_SERVER_READ_ONLY}, options);
        Ticket ticket = ((FlightEndpoint)sqlInfoFlightInfo.getEndpoints().get(0)).getTicket();
        FlightSql.CommandGetSqlInfo requestSqlInfoCommand = (FlightSql.CommandGetSqlInfo)FlightSqlUtils.unpackOrThrow((Any)Any.parseFrom((byte[])ticket.getBytes()), FlightSql.CommandGetSqlInfo.class);
        IntegrationAssertions.assertEquals(requestSqlInfoCommand.getInfo(0), 0);
        IntegrationAssertions.assertEquals(requestSqlInfoCommand.getInfo(1), 3);
        this.validate(FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA, sqlInfoFlightInfo, sqlClient);
        this.validateSchema(FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA, sqlClient.getSqlInfoSchema(options));
    }

    private void validateStatementExecution(FlightSqlClient sqlClient) throws Exception {
        FlightInfo info = sqlClient.execute("SELECT STATEMENT", new CallOption[0]);
        this.validate(FlightSqlScenarioProducer.getQuerySchema(), info, sqlClient);
        this.validateSchema(FlightSqlScenarioProducer.getQuerySchema(), sqlClient.getExecuteSchema("SELECT STATEMENT", new CallOption[0]));
        IntegrationAssertions.assertEquals(sqlClient.executeUpdate("UPDATE STATEMENT", new CallOption[0]), 10000L);
    }

    private void validatePreparedStatementExecution(BufferAllocator allocator, FlightSqlClient sqlClient) throws Exception {
        try (FlightSqlClient.PreparedStatement preparedStatement = sqlClient.prepare("SELECT PREPARED STATEMENT", new CallOption[0]);
             VectorSchemaRoot parameters = VectorSchemaRoot.create((Schema)FlightSqlScenarioProducer.getQuerySchema(), (BufferAllocator)allocator);){
            parameters.setRowCount(1);
            preparedStatement.setParameters(parameters);
            this.validate(FlightSqlScenarioProducer.getQuerySchema(), preparedStatement.execute(new CallOption[0]), sqlClient);
            this.validateSchema(FlightSqlScenarioProducer.getQuerySchema(), preparedStatement.fetchSchema(new CallOption[0]));
        }
        preparedStatement = sqlClient.prepare("UPDATE PREPARED STATEMENT", new CallOption[0]);
        try {
            IntegrationAssertions.assertEquals(preparedStatement.executeUpdate(new CallOption[0]), 20000L);
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    protected void validate(Schema expectedSchema, FlightInfo flightInfo, FlightSqlClient sqlClient) throws Exception {
        this.validate(expectedSchema, flightInfo, sqlClient, null);
    }

    protected void validate(Schema expectedSchema, FlightInfo flightInfo, FlightSqlClient sqlClient, Consumer<FlightStream> streamConsumer) throws Exception {
        Ticket ticket = ((FlightEndpoint)flightInfo.getEndpoints().get(0)).getTicket();
        try (FlightStream stream = sqlClient.getStream(ticket, new CallOption[0]);){
            Schema actualSchema = stream.getSchema();
            IntegrationAssertions.assertEquals(expectedSchema, actualSchema);
            if (!Objects.isNull(streamConsumer)) {
                streamConsumer.accept(stream);
            }
        }
    }

    protected void validateSchema(Schema expected, SchemaResult actual) {
        IntegrationAssertions.assertEquals(expected, actual.getSchema());
    }

    protected Map<Integer, Object> readSqlInfoStream(FlightStream stream) {
        HashMap<Integer, Object> infoValues = new HashMap<Integer, Object>();
        while (stream.next()) {
            UInt4Vector infoName = (UInt4Vector)stream.getRoot().getVector(0);
            DenseUnionVector value = (DenseUnionVector)stream.getRoot().getVector(1);
            for (int i = 0; i < stream.getRoot().getRowCount(); ++i) {
                Object object;
                int code = infoName.get(i);
                if (infoValues.containsKey(code)) {
                    throw new AssertionError((Object)("Duplicate SqlInfo value: " + code));
                }
                byte typeId = value.getTypeId(i);
                switch (typeId) {
                    case 0: {
                        object = ((Text)Preconditions.checkNotNull((Object)value.getVarCharVector(typeId).getObject(value.getOffset(i)))).toString();
                        break;
                    }
                    case 1: {
                        object = value.getBitVector(typeId).getObject(value.getOffset(i));
                        break;
                    }
                    case 2: {
                        object = value.getBigIntVector(typeId).getObject(value.getOffset(i));
                        break;
                    }
                    case 3: {
                        object = value.getIntVector(typeId).getObject(value.getOffset(i));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Decoding SqlInfo of type code " + typeId));
                    }
                }
                infoValues.put(code, object);
            }
        }
        return infoValues;
    }
}

