/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import org.apache.arrow.flight.Action;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightStatusCode;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.Result;
import org.apache.arrow.flight.auth.BasicClientAuthHandler;
import org.apache.arrow.flight.auth.BasicServerAuthHandler;
import org.apache.arrow.flight.auth.ClientAuthHandler;
import org.apache.arrow.flight.auth.ServerAuthHandler;
import org.apache.arrow.flight.integration.tests.IntegrationAssertions;
import org.apache.arrow.flight.integration.tests.Scenario;
import org.apache.arrow.memory.BufferAllocator;

final class AuthBasicProtoScenario
implements Scenario {
    static final String USERNAME = "arrow";
    static final String PASSWORD = "flight";

    AuthBasicProtoScenario() {
    }

    @Override
    public FlightProducer producer(BufferAllocator allocator, Location location) {
        return new NoOpFlightProducer(){

            public void doAction(FlightProducer.CallContext context, Action action, FlightProducer.StreamListener<Result> listener) {
                listener.onNext((Object)new Result(context.peerIdentity().getBytes(StandardCharsets.UTF_8)));
                listener.onCompleted();
            }
        };
    }

    @Override
    public void buildServer(FlightServer.Builder builder) {
        builder.authHandler((ServerAuthHandler)new BasicServerAuthHandler(new BasicServerAuthHandler.BasicAuthValidator(){

            public byte[] getToken(String username, String password) throws Exception {
                if (!AuthBasicProtoScenario.USERNAME.equals(username) || !AuthBasicProtoScenario.PASSWORD.equals(password)) {
                    throw CallStatus.UNAUTHENTICATED.withDescription("Username or password is invalid.").toRuntimeException();
                }
                return ("valid:" + username).getBytes(StandardCharsets.UTF_8);
            }

            public Optional<String> isValid(byte[] token) {
                String credential;
                if (token != null && (credential = new String(token, StandardCharsets.UTF_8)).startsWith("valid:")) {
                    return Optional.of(credential.substring(6));
                }
                return Optional.empty();
            }
        }));
    }

    @Override
    public void client(BufferAllocator allocator, Location location, FlightClient client) {
        FlightRuntimeException e = IntegrationAssertions.assertThrows(FlightRuntimeException.class, () -> client.listActions(new CallOption[0]).forEach(act -> {}));
        if (!FlightStatusCode.UNAUTHENTICATED.equals((Object)e.status().code())) {
            throw new AssertionError("Expected UNAUTHENTICATED but found " + String.valueOf(e.status().code()), (Throwable)e);
        }
        client.authenticate((ClientAuthHandler)new BasicClientAuthHandler(USERNAME, PASSWORD), new CallOption[0]);
        Result result = (Result)client.doAction(new Action(""), new CallOption[0]).next();
        if (!USERNAME.equals(new String(result.getBody(), StandardCharsets.UTF_8))) {
            throw new AssertionError((Object)("Expected arrow but got " + Arrays.toString(result.getBody())));
        }
    }
}

