/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.Criteria;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.PutResult;
import org.apache.arrow.flight.Result;
import org.apache.arrow.flight.SchemaResult;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.integration.tests.FlightSqlScenario;
import org.apache.arrow.flight.integration.tests.IntegrationAssertions;
import org.apache.arrow.flight.sql.CancelResult;
import org.apache.arrow.flight.sql.FlightSqlColumnMetadata;
import org.apache.arrow.flight.sql.FlightSqlProducer;
import org.apache.arrow.flight.sql.SqlInfoBuilder;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

public class FlightSqlScenarioProducer
implements FlightSqlProducer {
    public static final String SERVER_NAME = "Flight SQL Integration Test Server";
    private final BufferAllocator allocator;
    private final SqlInfoBuilder sqlInfoBuilder;

    public FlightSqlScenarioProducer(BufferAllocator allocator) {
        this.allocator = allocator;
        this.sqlInfoBuilder = new SqlInfoBuilder().withFlightSqlServerName(SERVER_NAME).withFlightSqlServerReadOnly(false).withFlightSqlServerSql(false).withFlightSqlServerSubstrait(true).withFlightSqlServerSubstraitMinVersion("min_version").withFlightSqlServerSubstraitMaxVersion("max_version").withFlightSqlServerTransaction(FlightSql.SqlSupportedTransaction.SQL_SUPPORTED_TRANSACTION_SAVEPOINT).withFlightSqlServerCancel(true).withFlightSqlServerStatementTimeout(42).withFlightSqlServerTransactionTimeout(7);
    }

    static Schema getQuerySchema() {
        return new Schema(Collections.singletonList(new Field("id", new FieldType(true, (ArrowType)new ArrowType.Int(64, true), null, new FlightSqlColumnMetadata.Builder().tableName("test").isAutoIncrement(true).isCaseSensitive(false).typeName("type_test").schemaName("schema_test").isSearchable(true).catalogName("catalog_test").precision(100).build().getMetadataMap()), null)));
    }

    static Schema getQueryWithTransactionSchema() {
        return new Schema(Collections.singletonList(new Field("pkey", new FieldType(true, (ArrowType)new ArrowType.Int(32, true), null, new FlightSqlColumnMetadata.Builder().tableName("test").isAutoIncrement(true).isCaseSensitive(false).typeName("type_test").schemaName("schema_test").isSearchable(true).catalogName("catalog_test").precision(100).build().getMetadataMap()), null)));
    }

    static Schema getIngestSchema() {
        return new Schema(Collections.singletonList(Field.nullable((String)"test_field", (ArrowType)new ArrowType.Int(64, true))));
    }

    protected SqlInfoBuilder getSqlInfoBuilder() {
        return this.sqlInfoBuilder;
    }

    public void beginSavepoint(FlightSql.ActionBeginSavepointRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<FlightSql.ActionBeginSavepointResult> listener) {
        if (!request.getName().equals("savepoint_name")) {
            listener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription(String.format("Expected name '%s', not '%s'", "savepoint_name", request.getName())).toRuntimeException());
            return;
        }
        if (!Arrays.equals(request.getTransactionId().toByteArray(), FlightSqlScenario.TRANSACTION_ID)) {
            listener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription(String.format("Expected transaction ID '%s', not '%s'", Arrays.toString(FlightSqlScenario.TRANSACTION_ID), Arrays.toString(request.getTransactionId().toByteArray()))).toRuntimeException());
            return;
        }
        listener.onNext((Object)FlightSql.ActionBeginSavepointResult.newBuilder().setSavepointId(ByteString.copyFrom((byte[])FlightSqlScenario.SAVEPOINT_ID)).build());
        listener.onCompleted();
    }

    public void beginTransaction(FlightSql.ActionBeginTransactionRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<FlightSql.ActionBeginTransactionResult> listener) {
        listener.onNext((Object)FlightSql.ActionBeginTransactionResult.newBuilder().setTransactionId(ByteString.copyFrom((byte[])FlightSqlScenario.TRANSACTION_ID)).build());
        listener.onCompleted();
    }

    public void cancelQuery(FlightInfo info, FlightProducer.CallContext context, FlightProducer.StreamListener<CancelResult> listener) {
        String expectedTicket = "PLAN HANDLE";
        if (info.getEndpoints().size() != 1) {
            listener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription(String.format("Expected 1 endpoint, got %d", info.getEndpoints().size())).toRuntimeException());
        }
        FlightEndpoint endpoint = (FlightEndpoint)info.getEndpoints().get(0);
        try {
            FlightSql.TicketStatementQuery ticket;
            Any any = Any.parseFrom((byte[])endpoint.getTicket().getBytes());
            if (!any.is(FlightSql.TicketStatementQuery.class)) {
                listener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription(String.format("Expected TicketStatementQuery, found '%s'", any.getTypeUrl())).toRuntimeException());
            }
            if (!(ticket = (FlightSql.TicketStatementQuery)any.unpack(FlightSql.TicketStatementQuery.class)).getStatementHandle().toStringUtf8().equals("PLAN HANDLE")) {
                listener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription(String.format("Expected ticket '%s'", "PLAN HANDLE")).toRuntimeException());
            }
            listener.onNext((Object)CancelResult.CANCELLED);
            listener.onCompleted();
        }
        catch (InvalidProtocolBufferException e) {
            listener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Invalid Protobuf:" + String.valueOf((Object)e)).withCause((Throwable)e).toRuntimeException());
        }
    }

    public void createPreparedStatement(FlightSql.ActionCreatePreparedStatementRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<Result> listener) {
        IntegrationAssertions.assertTrue("Expect to be one of the two queries used on tests", request.getQuery().equals("SELECT PREPARED STATEMENT") || request.getQuery().equals("UPDATE PREPARED STATEMENT"));
        Object text = request.getQuery();
        if (!request.getTransactionId().isEmpty()) {
            text = (String)text + " WITH TXN";
        }
        text = (String)text + " HANDLE";
        FlightSql.ActionCreatePreparedStatementResult result = FlightSql.ActionCreatePreparedStatementResult.newBuilder().setPreparedStatementHandle(ByteString.copyFromUtf8((String)text)).build();
        listener.onNext((Object)new Result(Any.pack((Message)result).toByteArray()));
        listener.onCompleted();
    }

    public void createPreparedSubstraitPlan(FlightSql.ActionCreatePreparedSubstraitPlanRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<FlightSql.ActionCreatePreparedStatementResult> listener) {
        if (!Arrays.equals(request.getPlan().getPlan().toByteArray(), FlightSqlScenario.SUBSTRAIT_PLAN_TEXT)) {
            listener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription(String.format("Expected plan '%s', not '%s'", Arrays.toString(FlightSqlScenario.SUBSTRAIT_PLAN_TEXT), Arrays.toString(request.getPlan().getPlan().toByteArray()))).toRuntimeException());
            return;
        }
        if (!"version".equals(request.getPlan().getVersion())) {
            listener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription(String.format("Expected version '%s', not '%s'", "version", request.getPlan().getVersion())).toRuntimeException());
            return;
        }
        String handle = request.getTransactionId().isEmpty() ? "PREPARED PLAN HANDLE" : "PREPARED PLAN WITH TXN HANDLE";
        FlightSql.ActionCreatePreparedStatementResult result = FlightSql.ActionCreatePreparedStatementResult.newBuilder().setPreparedStatementHandle(ByteString.copyFromUtf8((String)handle)).build();
        listener.onNext((Object)result);
        listener.onCompleted();
    }

    public void closePreparedStatement(FlightSql.ActionClosePreparedStatementRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<Result> listener) {
        String handle = request.getPreparedStatementHandle().toStringUtf8();
        IntegrationAssertions.assertTrue("Expect to be one of the queries used on tests", handle.equals("SELECT PREPARED STATEMENT HANDLE") || handle.equals("SELECT PREPARED STATEMENT WITH TXN HANDLE") || handle.equals("UPDATE PREPARED STATEMENT HANDLE") || handle.equals("UPDATE PREPARED STATEMENT WITH TXN HANDLE") || handle.equals("PREPARED PLAN HANDLE") || handle.equals("PREPARED PLAN WITH TXN HANDLE"));
        listener.onCompleted();
    }

    public void endSavepoint(FlightSql.ActionEndSavepointRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<Result> listener) {
        switch (request.getAction()) {
            case END_SAVEPOINT_RELEASE: 
            case END_SAVEPOINT_ROLLBACK: {
                if (Arrays.equals(request.getSavepointId().toByteArray(), FlightSqlScenario.SAVEPOINT_ID)) break;
                listener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Unexpected ID: " + Arrays.toString(request.getSavepointId().toByteArray())).toRuntimeException());
                break;
            }
            default: {
                listener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Unknown action: " + String.valueOf(request.getAction())).toRuntimeException());
                return;
            }
        }
        listener.onCompleted();
    }

    public void endTransaction(FlightSql.ActionEndTransactionRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<Result> listener) {
        switch (request.getAction()) {
            case END_TRANSACTION_COMMIT: 
            case END_TRANSACTION_ROLLBACK: {
                if (Arrays.equals(request.getTransactionId().toByteArray(), FlightSqlScenario.TRANSACTION_ID)) break;
                listener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Unexpected ID: " + Arrays.toString(request.getTransactionId().toByteArray())).toRuntimeException());
                break;
            }
            default: {
                listener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Unknown action: " + String.valueOf(request.getAction())).toRuntimeException());
                return;
            }
        }
        listener.onCompleted();
    }

    public FlightInfo getFlightInfoStatement(FlightSql.CommandStatementQuery command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(command.getQuery(), "SELECT STATEMENT");
        if (command.getTransactionId().isEmpty()) {
            String handle = "SELECT STATEMENT HANDLE";
            FlightSql.TicketStatementQuery ticket = FlightSql.TicketStatementQuery.newBuilder().setStatementHandle(ByteString.copyFromUtf8((String)handle)).build();
            return this.getFlightInfoForSchema(ticket, descriptor, FlightSqlScenarioProducer.getQuerySchema());
        }
        String handle = "SELECT STATEMENT WITH TXN HANDLE";
        FlightSql.TicketStatementQuery ticket = FlightSql.TicketStatementQuery.newBuilder().setStatementHandle(ByteString.copyFromUtf8((String)handle)).build();
        return this.getFlightInfoForSchema(ticket, descriptor, FlightSqlScenarioProducer.getQueryWithTransactionSchema());
    }

    public FlightInfo getFlightInfoSubstraitPlan(FlightSql.CommandStatementSubstraitPlan command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(command.getPlan().getPlan().toByteArray(), FlightSqlScenario.SUBSTRAIT_PLAN_TEXT);
        IntegrationAssertions.assertEquals(command.getPlan().getVersion(), "version");
        String handle = command.getTransactionId().isEmpty() ? "PLAN HANDLE" : "PLAN WITH TXN HANDLE";
        FlightSql.TicketStatementQuery ticket = FlightSql.TicketStatementQuery.newBuilder().setStatementHandle(ByteString.copyFromUtf8((String)handle)).build();
        return this.getFlightInfoForSchema(ticket, descriptor, FlightSqlScenarioProducer.getQuerySchema());
    }

    public FlightInfo getFlightInfoPreparedStatement(FlightSql.CommandPreparedStatementQuery command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        String handle = command.getPreparedStatementHandle().toStringUtf8();
        if (handle.equals("SELECT PREPARED STATEMENT HANDLE") || handle.equals("PREPARED PLAN HANDLE")) {
            return this.getFlightInfoForSchema(command, descriptor, FlightSqlScenarioProducer.getQuerySchema());
        }
        if (handle.equals("SELECT PREPARED STATEMENT WITH TXN HANDLE") || handle.equals("PREPARED PLAN WITH TXN HANDLE")) {
            return this.getFlightInfoForSchema(command, descriptor, FlightSqlScenarioProducer.getQueryWithTransactionSchema());
        }
        throw CallStatus.INVALID_ARGUMENT.withDescription("Unknown handle: " + handle).toRuntimeException();
    }

    public SchemaResult getSchemaStatement(FlightSql.CommandStatementQuery command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(command.getQuery(), "SELECT STATEMENT");
        if (command.getTransactionId().isEmpty()) {
            return new SchemaResult(FlightSqlScenarioProducer.getQuerySchema());
        }
        return new SchemaResult(FlightSqlScenarioProducer.getQueryWithTransactionSchema());
    }

    public SchemaResult getSchemaPreparedStatement(FlightSql.CommandPreparedStatementQuery command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        String handle = command.getPreparedStatementHandle().toStringUtf8();
        if (handle.equals("SELECT PREPARED STATEMENT HANDLE") || handle.equals("PREPARED PLAN HANDLE")) {
            return new SchemaResult(FlightSqlScenarioProducer.getQuerySchema());
        }
        if (handle.equals("SELECT PREPARED STATEMENT WITH TXN HANDLE") || handle.equals("PREPARED PLAN WITH TXN HANDLE")) {
            return new SchemaResult(FlightSqlScenarioProducer.getQueryWithTransactionSchema());
        }
        throw CallStatus.INVALID_ARGUMENT.withDescription("Unknown handle: " + handle).toRuntimeException();
    }

    public SchemaResult getSchemaSubstraitPlan(FlightSql.CommandStatementSubstraitPlan command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        if (!Arrays.equals(command.getPlan().getPlan().toByteArray(), FlightSqlScenario.SUBSTRAIT_PLAN_TEXT)) {
            throw CallStatus.INVALID_ARGUMENT.withDescription(String.format("Expected plan '%s', not '%s'", Arrays.toString(FlightSqlScenario.SUBSTRAIT_PLAN_TEXT), Arrays.toString(command.getPlan().getPlan().toByteArray()))).toRuntimeException();
        }
        if (!"version".equals(command.getPlan().getVersion())) {
            throw CallStatus.INVALID_ARGUMENT.withDescription(String.format("Expected version '%s', not '%s'", "version", command.getPlan().getVersion())).toRuntimeException();
        }
        if (command.getTransactionId().isEmpty()) {
            return new SchemaResult(FlightSqlScenarioProducer.getQuerySchema());
        }
        return new SchemaResult(FlightSqlScenarioProducer.getQueryWithTransactionSchema());
    }

    public void getStreamStatement(FlightSql.TicketStatementQuery ticket, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        String handle = ticket.getStatementHandle().toStringUtf8();
        if (handle.equals("SELECT STATEMENT HANDLE") || handle.equals("PLAN HANDLE")) {
            this.putEmptyBatchToStreamListener(listener, FlightSqlScenarioProducer.getQuerySchema());
        } else if (handle.equals("SELECT STATEMENT WITH TXN HANDLE") || handle.equals("PLAN WITH TXN HANDLE")) {
            this.putEmptyBatchToStreamListener(listener, FlightSqlScenarioProducer.getQueryWithTransactionSchema());
        } else {
            listener.error((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Unknown handle: " + handle).toRuntimeException());
        }
    }

    public void getStreamPreparedStatement(FlightSql.CommandPreparedStatementQuery command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        String handle = command.getPreparedStatementHandle().toStringUtf8();
        if (handle.equals("SELECT PREPARED STATEMENT HANDLE") || handle.equals("PREPARED PLAN HANDLE")) {
            this.putEmptyBatchToStreamListener(listener, FlightSqlScenarioProducer.getQuerySchema());
        } else if (handle.equals("SELECT PREPARED STATEMENT WITH TXN HANDLE") || handle.equals("PREPARED PLAN WITH TXN HANDLE")) {
            this.putEmptyBatchToStreamListener(listener, FlightSqlScenarioProducer.getQueryWithTransactionSchema());
        } else {
            listener.error((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Unknown handle: " + handle).toRuntimeException());
        }
    }

    private Runnable acceptPutReturnConstant(FlightProducer.StreamListener<PutResult> ackStream, long value) {
        return () -> {
            FlightSql.DoPutUpdateResult build = FlightSql.DoPutUpdateResult.newBuilder().setRecordCount(value).build();
            try (ArrowBuf buffer = this.allocator.buffer((long)build.getSerializedSize());){
                buffer.writeBytes(build.toByteArray());
                ackStream.onNext((Object)PutResult.metadata((ArrowBuf)buffer));
                ackStream.onCompleted();
            }
        };
    }

    public Runnable acceptPutStatement(FlightSql.CommandStatementUpdate command, FlightProducer.CallContext context, FlightStream flightStream, FlightProducer.StreamListener<PutResult> ackStream) {
        IntegrationAssertions.assertEquals(command.getQuery(), "UPDATE STATEMENT");
        return this.acceptPutReturnConstant(ackStream, command.getTransactionId().isEmpty() ? 10000L : 15000L);
    }

    public Runnable acceptPutStatementBulkIngest(FlightSql.CommandStatementIngest command, FlightProducer.CallContext context, FlightStream flightStream, FlightProducer.StreamListener<PutResult> ackStream) {
        IntegrationAssertions.assertEquals(FlightSql.CommandStatementIngest.TableDefinitionOptions.TableExistsOption.TABLE_EXISTS_OPTION_REPLACE, command.getTableDefinitionOptions().getIfExists());
        IntegrationAssertions.assertEquals(FlightSql.CommandStatementIngest.TableDefinitionOptions.TableNotExistOption.TABLE_NOT_EXIST_OPTION_CREATE, command.getTableDefinitionOptions().getIfNotExist());
        IntegrationAssertions.assertEquals("test_table", command.getTable());
        IntegrationAssertions.assertEquals("test_catalog", command.getCatalog());
        IntegrationAssertions.assertEquals("test_schema", command.getSchema());
        IntegrationAssertions.assertEquals(true, command.getTemporary());
        IntegrationAssertions.assertEquals(FlightSqlScenario.BULK_INGEST_TRANSACTION_ID, command.getTransactionId().toByteArray());
        HashMap expectedOptions = new HashMap(ImmutableMap.of((Object)"key1", (Object)"val1", (Object)"key2", (Object)"val2"));
        IntegrationAssertions.assertEquals(expectedOptions.size(), command.getOptionsCount());
        for (Map.Entry optionEntry : expectedOptions.entrySet()) {
            String key = (String)optionEntry.getKey();
            IntegrationAssertions.assertEquals(optionEntry.getValue(), command.getOptionsOrThrow(key));
        }
        IntegrationAssertions.assertEquals(FlightSqlScenarioProducer.getIngestSchema(), flightStream.getSchema());
        long rowCount = 0L;
        while (flightStream.next()) {
            rowCount += (long)flightStream.getRoot().getRowCount();
        }
        return this.acceptPutReturnConstant(ackStream, rowCount);
    }

    public Runnable acceptPutSubstraitPlan(FlightSql.CommandStatementSubstraitPlan command, FlightProducer.CallContext context, FlightStream flightStream, FlightProducer.StreamListener<PutResult> ackStream) {
        IntegrationAssertions.assertEquals(command.getPlan().getPlan().toByteArray(), FlightSqlScenario.SUBSTRAIT_PLAN_TEXT);
        IntegrationAssertions.assertEquals(command.getPlan().getVersion(), "version");
        return this.acceptPutReturnConstant(ackStream, command.getTransactionId().isEmpty() ? 10000L : 15000L);
    }

    public Runnable acceptPutPreparedStatementUpdate(FlightSql.CommandPreparedStatementUpdate command, FlightProducer.CallContext context, FlightStream flightStream, FlightProducer.StreamListener<PutResult> ackStream) {
        String handle = command.getPreparedStatementHandle().toStringUtf8();
        if (handle.equals("UPDATE PREPARED STATEMENT HANDLE") || handle.equals("PREPARED PLAN HANDLE")) {
            return this.acceptPutReturnConstant(ackStream, 20000L);
        }
        if (handle.equals("UPDATE PREPARED STATEMENT WITH TXN HANDLE") || handle.equals("PREPARED PLAN WITH TXN HANDLE")) {
            return this.acceptPutReturnConstant(ackStream, 25000L);
        }
        return () -> ackStream.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Unknown handle: " + handle).toRuntimeException());
    }

    public Runnable acceptPutPreparedStatementQuery(FlightSql.CommandPreparedStatementQuery command, FlightProducer.CallContext context, FlightStream flightStream, FlightProducer.StreamListener<PutResult> ackStream) {
        String handle = command.getPreparedStatementHandle().toStringUtf8();
        if (handle.equals("SELECT PREPARED STATEMENT HANDLE") || handle.equals("SELECT PREPARED STATEMENT WITH TXN HANDLE") || handle.equals("PREPARED PLAN HANDLE") || handle.equals("PREPARED PLAN WITH TXN HANDLE")) {
            IntegrationAssertions.assertEquals(FlightSqlScenarioProducer.getQuerySchema(), flightStream.getSchema());
            return () -> ackStream.onCompleted();
        }
        return () -> ackStream.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Unknown handle: " + handle).toRuntimeException());
    }

    public FlightInfo getFlightInfoSqlInfo(FlightSql.CommandGetSqlInfo request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA);
    }

    public void getStreamSqlInfo(FlightSql.CommandGetSqlInfo command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        if (command.getInfoCount() == 2 && command.getInfo(0) == 0 && command.getInfo(1) == 3) {
            this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA);
            return;
        }
        this.sqlInfoBuilder.send(command.getInfoList(), listener);
    }

    public void getStreamTypeInfo(FlightSql.CommandGetXdbcTypeInfo request, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_TYPE_INFO_SCHEMA);
    }

    public FlightInfo getFlightInfoTypeInfo(FlightSql.CommandGetXdbcTypeInfo request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_TYPE_INFO_SCHEMA);
    }

    public FlightInfo getFlightInfoCatalogs(FlightSql.CommandGetCatalogs request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_CATALOGS_SCHEMA);
    }

    private void putEmptyBatchToStreamListener(FlightProducer.ServerStreamListener stream, Schema schema) {
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);){
            stream.start(root);
            stream.putNext();
            stream.completed();
        }
    }

    public void getStreamCatalogs(FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_CATALOGS_SCHEMA);
    }

    public FlightInfo getFlightInfoSchemas(FlightSql.CommandGetDbSchemas request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(request.getCatalog(), "catalog");
        IntegrationAssertions.assertEquals(request.getDbSchemaFilterPattern(), "db_schema_filter_pattern");
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_SCHEMAS_SCHEMA);
    }

    public void getStreamSchemas(FlightSql.CommandGetDbSchemas command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_SCHEMAS_SCHEMA);
    }

    public FlightInfo getFlightInfoTables(FlightSql.CommandGetTables request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(request.getCatalog(), "catalog");
        IntegrationAssertions.assertEquals(request.getDbSchemaFilterPattern(), "db_schema_filter_pattern");
        IntegrationAssertions.assertEquals(request.getTableNameFilterPattern(), "table_filter_pattern");
        IntegrationAssertions.assertEquals(request.getTableTypesCount(), 2);
        IntegrationAssertions.assertEquals(request.getTableTypes(0), "table");
        IntegrationAssertions.assertEquals(request.getTableTypes(1), "view");
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_TABLES_SCHEMA);
    }

    public void getStreamTables(FlightSql.CommandGetTables command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_TABLES_SCHEMA);
    }

    public FlightInfo getFlightInfoTableTypes(FlightSql.CommandGetTableTypes request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_TABLE_TYPES_SCHEMA);
    }

    public void getStreamTableTypes(FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_TABLE_TYPES_SCHEMA);
    }

    public FlightInfo getFlightInfoPrimaryKeys(FlightSql.CommandGetPrimaryKeys request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(request.getCatalog(), "catalog");
        IntegrationAssertions.assertEquals(request.getDbSchema(), "db_schema");
        IntegrationAssertions.assertEquals(request.getTable(), "table");
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_PRIMARY_KEYS_SCHEMA);
    }

    public void getStreamPrimaryKeys(FlightSql.CommandGetPrimaryKeys command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_PRIMARY_KEYS_SCHEMA);
    }

    public FlightInfo getFlightInfoExportedKeys(FlightSql.CommandGetExportedKeys request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(request.getCatalog(), "catalog");
        IntegrationAssertions.assertEquals(request.getDbSchema(), "db_schema");
        IntegrationAssertions.assertEquals(request.getTable(), "table");
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_EXPORTED_KEYS_SCHEMA);
    }

    public FlightInfo getFlightInfoImportedKeys(FlightSql.CommandGetImportedKeys request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(request.getCatalog(), "catalog");
        IntegrationAssertions.assertEquals(request.getDbSchema(), "db_schema");
        IntegrationAssertions.assertEquals(request.getTable(), "table");
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_IMPORTED_KEYS_SCHEMA);
    }

    public FlightInfo getFlightInfoCrossReference(FlightSql.CommandGetCrossReference request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(request.getPkCatalog(), "pk_catalog");
        IntegrationAssertions.assertEquals(request.getPkDbSchema(), "pk_db_schema");
        IntegrationAssertions.assertEquals(request.getPkTable(), "pk_table");
        IntegrationAssertions.assertEquals(request.getFkCatalog(), "fk_catalog");
        IntegrationAssertions.assertEquals(request.getFkDbSchema(), "fk_db_schema");
        IntegrationAssertions.assertEquals(request.getFkTable(), "fk_table");
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_CROSS_REFERENCE_SCHEMA);
    }

    public void getStreamExportedKeys(FlightSql.CommandGetExportedKeys command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_EXPORTED_KEYS_SCHEMA);
    }

    public void getStreamImportedKeys(FlightSql.CommandGetImportedKeys command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_IMPORTED_KEYS_SCHEMA);
    }

    public void getStreamCrossReference(FlightSql.CommandGetCrossReference command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_CROSS_REFERENCE_SCHEMA);
    }

    public void close() throws Exception {
    }

    public void listFlights(FlightProducer.CallContext context, Criteria criteria, FlightProducer.StreamListener<FlightInfo> listener) {
    }

    private <T extends Message> FlightInfo getFlightInfoForSchema(T request, FlightDescriptor descriptor, Schema schema) {
        Ticket ticket = new Ticket(Any.pack(request).toByteArray());
        List<FlightEndpoint> endpoints = Collections.singletonList(new FlightEndpoint(ticket, new Location[0]));
        return new FlightInfo(schema, descriptor, endpoints, -1L, -1L);
    }
}

