/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.integration.tests.IntegrationAssertions;
import org.apache.arrow.flight.integration.tests.Scenario;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.types.pojo.Schema;

public class LocationReuseConnectionScenario
implements Scenario {
    @Override
    public FlightProducer producer(BufferAllocator allocator, Location location) throws Exception {
        return new ReuseConnectionProducer();
    }

    @Override
    public void buildServer(FlightServer.Builder builder) throws Exception {
    }

    @Override
    public void client(BufferAllocator allocator, Location location, FlightClient client) throws Exception {
        FlightInfo info = client.getInfo(FlightDescriptor.command((byte[])"reuse".getBytes(StandardCharsets.UTF_8)), new CallOption[0]);
        IntegrationAssertions.assertEquals(1, info.getEndpoints().size());
        IntegrationAssertions.assertEquals(1, ((FlightEndpoint)info.getEndpoints().get(0)).getLocations().size());
        Location actual = (Location)((FlightEndpoint)info.getEndpoints().get(0)).getLocations().get(0);
        IntegrationAssertions.assertEquals(Location.reuseConnection().getUri(), actual.getUri());
    }

    private static class ReuseConnectionProducer
    extends NoOpFlightProducer {
        private ReuseConnectionProducer() {
        }

        public FlightInfo getFlightInfo(FlightProducer.CallContext context, FlightDescriptor descriptor) {
            List<FlightEndpoint> endpoints = Collections.singletonList(new FlightEndpoint(new Ticket(new byte[0]), new Location[]{Location.reuseConnection()}));
            return new FlightInfo(new Schema(Collections.emptyList()), descriptor, endpoints, -1L, -1L);
        }
    }
}

