/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.file.ArrowBlock;
import org.apache.arrow.vector.file.ArrowFooter;
import org.apache.arrow.vector.file.ArrowReader;
import org.apache.arrow.vector.file.ArrowWriter;
import org.apache.arrow.vector.schema.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRoundtrip {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileRoundtrip.class);
    private final Options options;
    private final PrintStream out;
    private final PrintStream err;

    public static void main(String[] args) {
        System.exit(new FileRoundtrip(System.out, System.err).run(args));
    }

    FileRoundtrip(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
        this.options = new Options();
        this.options.addOption("i", "in", true, "input file");
        this.options.addOption("o", "out", true, "output file");
    }

    private File validateFile(String type, String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("missing " + type + " file parameter");
        }
        File f = new File(fileName);
        if (!f.exists() || f.isDirectory()) {
            throw new IllegalArgumentException(type + " file not found: " + f.getAbsolutePath());
        }
        return f;
    }

    int run(String[] args) {
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(this.options, args, false);
            String inFileName = cmd.getOptionValue("in");
            String outFileName = cmd.getOptionValue("out");
            File inFile = this.validateFile("input", inFileName);
            File outFile = this.validateFile("output", outFileName);
            RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
            try (FileInputStream fileInputStream = new FileInputStream(inFile);
                 ArrowReader arrowReader = new ArrowReader((SeekableByteChannel)fileInputStream.getChannel(), (BufferAllocator)allocator);){
                ArrowFooter footer = arrowReader.readFooter();
                Schema schema = footer.getSchema();
                LOGGER.debug("Input file size: " + inFile.length());
                LOGGER.debug("Found schema: " + schema);
                try (FileOutputStream fileOutputStream = new FileOutputStream(outFile);
                     ArrowWriter arrowWriter = new ArrowWriter((WritableByteChannel)fileOutputStream.getChannel(), schema);){
                    List recordBatches = footer.getRecordBatches();
                    for (ArrowBlock rbBlock : recordBatches) {
                        ArrowRecordBatch inRecordBatch = arrowReader.readRecordBatch(rbBlock);
                        Throwable throwable = null;
                        try {
                            VectorSchemaRoot root = new VectorSchemaRoot(schema, (BufferAllocator)allocator);
                            Throwable throwable2 = null;
                            try {
                                VectorLoader vectorLoader = new VectorLoader(root);
                                vectorLoader.load(inRecordBatch);
                                VectorUnloader vectorUnloader = new VectorUnloader(root);
                                ArrowRecordBatch recordBatch = vectorUnloader.getRecordBatch();
                                arrowWriter.writeRecordBatch(recordBatch);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (root == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        root.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                root.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (inRecordBatch == null) continue;
                            if (throwable != null) {
                                try {
                                    inRecordBatch.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            inRecordBatch.close();
                        }
                    }
                }
                LOGGER.debug("Output file size: " + outFile.length());
            }
        }
        catch (ParseException e) {
            return this.fatalError("Invalid parameters", e);
        }
        catch (IOException e) {
            return this.fatalError("Error accessing files", e);
        }
        return 0;
    }

    private int fatalError(String message, Throwable e) {
        this.err.println(message);
        LOGGER.error(message, e);
        return 1;
    }
}

