/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.concurrent.TimeUnit;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.holders.NullableVarCharHolder;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
public class VariableWidthVectorInlineValueBenchmarks {
    private static final int VECTOR_CAPACITY = 16384;
    private static final int VECTOR_LENGTH = 1024;
    private static final int ALLOCATOR_CAPACITY = 0x100000;
    private static final byte[] bytes = "InlineValue".getBytes();
    private ArrowBuf arrowBuff;
    private BufferAllocator allocator;
    private VarCharVector vector;
    @Param(value={"1", "2", "10", "40"})
    private int step;

    @Setup(value=Level.Iteration)
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
        this.vector = new VarCharVector("vector", this.allocator);
        this.vector.allocateNew(16384L, 1024);
        this.arrowBuff = this.allocator.buffer(1024L);
        this.arrowBuff.setBytes(0L, bytes, 0, (long)bytes.length);
    }

    @TearDown(value=Level.Iteration)
    public void tearDown() {
        this.arrowBuff.close();
        this.vector.close();
        this.allocator.close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public int setSafeFromArray() {
        for (int i = 0; i < 500; ++i) {
            this.vector.setSafe(i * this.step, bytes);
        }
        return this.vector.getBufferSize();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public int setSafeFromNullableVarcharHolder() {
        NullableVarCharHolder nvch = new NullableVarCharHolder();
        nvch.buffer = this.arrowBuff;
        nvch.start = 0;
        nvch.end = bytes.length;
        for (int i = 0; i < 50; ++i) {
            nvch.isSet = 0;
            for (int j = 0; j < 9; ++j) {
                int idx = 10 * i + j;
                this.vector.setSafe(idx, nvch);
            }
            nvch.isSet = 1;
            this.vector.setSafe(10 * (i + 1), nvch);
        }
        return this.vector.getBufferSize();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(VariableWidthVectorInlineValueBenchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }
}

