/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.concurrent.TimeUnit;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.ValueVector;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
public class Float8Benchmarks {
    private static final int VECTOR_LENGTH = 1024;
    private static final int ALLOCATOR_CAPACITY = 0x100000;
    private BufferAllocator allocator;
    private Float8Vector vector;
    private Float8Vector fromVector;

    @Setup
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
        this.vector = new Float8Vector("vector", this.allocator);
        this.vector.allocateNew(1024);
        this.fromVector = new Float8Vector("vector", this.allocator);
        this.fromVector.allocateNew(1024);
        for (int i = 0; i < 1024; ++i) {
            if (i % 3 == 0) {
                this.fromVector.setNull(i);
                continue;
            }
            this.fromVector.set(i, (double)(i * i));
        }
        this.fromVector.setValueCount(1024);
    }

    @TearDown
    public void tearDown() {
        this.vector.close();
        this.fromVector.close();
        this.allocator.close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public double readWriteBenchmark() {
        double sum = 0.0;
        for (int i = 0; i < 1024; ++i) {
            this.vector.set(i, (double)i + 10.0);
            sum += this.vector.get(i);
        }
        return sum;
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void copyFromBenchmark() {
        for (int i = 0; i < 1024; ++i) {
            this.vector.copyFrom(i, i, (ValueVector)this.fromVector);
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(Float8Benchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }
}

