/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.concurrent.TimeUnit;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class BitVectorHelperBenchmarks {
    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public int getNullCountBenchmark(BenchmarkState state) {
        return BitVectorHelper.getNullCount((ArrowBuf)state.validityBuffer, (int)1024);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public boolean allBitsNullBenchmark(BenchmarkState state) {
        return BitVectorHelper.checkAllBitsEqualTo((ArrowBuf)state.oneBitValidityBuffer, (int)1024, (boolean)true);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public void loadValidityBufferAllOne(NonNullableValidityBufferState state) {
        state.loadResult = BitVectorHelper.loadValidityBuffer((ArrowFieldNode)state.fieldNode, (ArrowBuf)state.validityBuffer, (BufferAllocator)state.allocator);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void setValidityBitBenchmark(ClearBitStateState state) {
        for (int i = 0; i < 1024; ++i) {
            BitVectorHelper.setValidityBit((ArrowBuf)state.validityBuffer, (int)i, (int)state.bitToSet);
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void setValidityBitToZeroBenchmark(ClearBitStateState state) {
        for (int i = 0; i < 1024; ++i) {
            BitVectorHelper.unsetBit((ArrowBuf)state.validityBuffer, (int)i);
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(BitVectorHelperBenchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Benchmark)
    public static class BenchmarkState {
        private static final int VALIDITY_BUFFER_CAPACITY = 1024;
        private static final int ALLOCATOR_CAPACITY = 0x100000;
        private BufferAllocator allocator;
        private ArrowBuf validityBuffer;
        private ArrowBuf oneBitValidityBuffer;

        @Setup(value=Level.Trial)
        public void prepare() {
            this.allocator = new RootAllocator(0x100000L);
            this.validityBuffer = this.allocator.buffer(128L);
            for (int i = 0; i < 1024; ++i) {
                if (i % 7 == 0) {
                    BitVectorHelper.setBit((ArrowBuf)this.validityBuffer, (long)i);
                    continue;
                }
                BitVectorHelper.unsetBit((ArrowBuf)this.validityBuffer, (int)i);
            }
            this.oneBitValidityBuffer = this.allocator.buffer(128L);
            this.oneBitValidityBuffer.setZero(0L, 128L);
            BitVectorHelper.setBit((ArrowBuf)this.oneBitValidityBuffer, (long)512L);
        }

        @TearDown(value=Level.Trial)
        public void tearDown() {
            this.validityBuffer.close();
            this.oneBitValidityBuffer.close();
            this.allocator.close();
        }
    }

    @State(value=Scope.Benchmark)
    public static class NonNullableValidityBufferState {
        private static final int VALIDITY_BUFFER_CAPACITY = 1024;
        private static final int ALLOCATOR_CAPACITY = 0x100000;
        private BufferAllocator allocator;
        private ArrowBuf validityBuffer;
        private ArrowBuf loadResult;
        private ArrowFieldNode fieldNode;

        @Setup(value=Level.Trial)
        public void prepare() {
            this.allocator = new RootAllocator(0x100000L);
            this.validityBuffer = this.allocator.buffer(128L);
            for (int i = 0; i < 1024; ++i) {
                BitVectorHelper.setBit((ArrowBuf)this.validityBuffer, (long)i);
            }
            this.fieldNode = new ArrowFieldNode(1024L, 0L);
        }

        @TearDown(value=Level.Invocation)
        public void tearDownInvoke() {
            this.loadResult.close();
        }

        @TearDown(value=Level.Trial)
        public void tearDown() {
            this.validityBuffer.close();
            this.allocator.close();
        }
    }

    @State(value=Scope.Benchmark)
    public static class ClearBitStateState {
        private static final int VALIDITY_BUFFER_CAPACITY = 1024;
        private static final int ALLOCATOR_CAPACITY = 0x100000;
        private BufferAllocator allocator;
        private ArrowBuf validityBuffer;
        private int bitToSet = 0;

        @Setup(value=Level.Trial)
        public void prepare() {
            this.allocator = new RootAllocator(0x100000L);
            this.validityBuffer = this.allocator.buffer(128L);
        }

        @TearDown(value=Level.Trial)
        public void tearDown() {
            this.validityBuffer.close();
            this.allocator.close();
        }
    }
}

