/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import io.netty.buffer.PooledByteBufAllocatorL;
import io.netty.buffer.UnsafeDirectLittleEndian;
import org.apache.arrow.memory.AllocationManager;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.util.LargeMemoryUtil;

public class NettyAllocationManager
extends AllocationManager {
    public static final Factory FACTORY = new Factory();
    private static final PooledByteBufAllocatorL INNER_ALLOCATOR = new PooledByteBufAllocatorL();
    static final UnsafeDirectLittleEndian EMPTY = NettyAllocationManager.INNER_ALLOCATOR.empty;
    static final long CHUNK_SIZE = INNER_ALLOCATOR.getChunkSize();
    private final int allocatedSize;
    private final UnsafeDirectLittleEndian memoryChunk;

    NettyAllocationManager(BaseAllocator accountingAllocator, int requestedSize) {
        super(accountingAllocator);
        this.memoryChunk = INNER_ALLOCATOR.allocate(requestedSize);
        this.allocatedSize = this.memoryChunk.capacity();
    }

    UnsafeDirectLittleEndian getMemoryChunk() {
        return this.memoryChunk;
    }

    @Override
    protected long memoryAddress() {
        return this.memoryChunk.memoryAddress();
    }

    @Override
    protected void release0() {
        this.memoryChunk.release();
    }

    @Override
    public long getSize() {
        return this.allocatedSize;
    }

    public static class Factory
    implements AllocationManager.Factory {
        private Factory() {
        }

        @Override
        public AllocationManager create(BaseAllocator accountingAllocator, long size) {
            return new NettyAllocationManager(accountingAllocator, LargeMemoryUtil.checkedCastToInt(size));
        }
    }
}

