/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.compression;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.compression.AbstractCompressionCodec;
import org.apache.arrow.vector.compression.CompressionUtil;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class Lz4CompressionCodec
extends AbstractCompressionCodec {
    protected ArrowBuf doCompress(BufferAllocator allocator, ArrowBuf uncompressedBuffer) {
        Preconditions.checkArgument((uncompressedBuffer.writerIndex() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"The uncompressed buffer size exceeds the integer limit %s.", (int)Integer.MAX_VALUE);
        byte[] inBytes = new byte[(int)uncompressedBuffer.writerIndex()];
        uncompressedBuffer.getBytes(0L, inBytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ByteArrayInputStream in = new ByteArrayInputStream(inBytes);
             FramedLZ4CompressorOutputStream out = new FramedLZ4CompressorOutputStream((OutputStream)baos);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] outBytes = baos.toByteArray();
        ArrowBuf compressedBuffer = allocator.buffer(8L + (long)outBytes.length);
        compressedBuffer.setBytes(8L, outBytes);
        compressedBuffer.writerIndex(8L + (long)outBytes.length);
        return compressedBuffer;
    }

    protected ArrowBuf doDecompress(BufferAllocator allocator, ArrowBuf compressedBuffer) {
        Preconditions.checkArgument((compressedBuffer.writerIndex() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"The compressed buffer size exceeds the integer limit %s", (int)Integer.MAX_VALUE);
        long decompressedLength = this.readUncompressedLength(compressedBuffer);
        byte[] inBytes = new byte[(int)(compressedBuffer.writerIndex() - 8L)];
        compressedBuffer.getBytes(8L, inBytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)decompressedLength);
        try (FramedLZ4CompressorInputStream in = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(inBytes));){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] outBytes = out.toByteArray();
        ArrowBuf decompressedBuffer = allocator.buffer((long)outBytes.length);
        decompressedBuffer.setBytes(0L, outBytes);
        return decompressedBuffer;
    }

    public CompressionUtil.CodecType getCodecType() {
        return CompressionUtil.CodecType.LZ4_FRAME;
    }
}

