/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.util.ArrayList;
import java.util.Map;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.CDataDictionaryProvider;
import org.apache.arrow.c.Format;
import org.apache.arrow.c.Metadata;
import org.apache.arrow.c.NativeUtil;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.ExtensionTypeRegistry;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SchemaImporter {
    private static final Logger logger = LoggerFactory.getLogger(SchemaImporter.class);
    private static final int MAX_IMPORT_RECURSION_LEVEL = 64;
    private long nextDictionaryID = 1L;
    private final BufferAllocator allocator;

    public SchemaImporter(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    Field importField(ArrowSchema schema, CDataDictionaryProvider provider) {
        return this.importField(schema, provider, 0);
    }

    private Field importField(ArrowSchema schema, CDataDictionaryProvider provider, int recursionLevel) {
        Preconditions.checkState((recursionLevel <= 64 ? 1 : 0) != 0, (Object)"Recursion level in ArrowSchema struct exceeded");
        ArrowSchema.Snapshot snapshot = schema.snapshot();
        Preconditions.checkState((snapshot.release != 0L ? 1 : 0) != 0, (Object)"Cannot import released ArrowSchema");
        String name = NativeUtil.toJavaString(snapshot.name);
        String format = NativeUtil.toJavaString(snapshot.format);
        Preconditions.checkNotNull((Object)format, (Object)"format field must not be null");
        ArrowType arrowType = Format.asType(format, snapshot.flags);
        boolean nullable = (snapshot.flags & 2L) != 0L;
        Map<String, String> metadata = Metadata.decode(snapshot.metadata);
        if (metadata != null && metadata.containsKey("ARROW:extension:name")) {
            String extensionName = metadata.get("ARROW:extension:name");
            String extensionMetadata = metadata.getOrDefault("ARROW:extension:metadata", "");
            ArrowType.ExtensionType extensionType = ExtensionTypeRegistry.lookup((String)extensionName);
            if (extensionType != null) {
                arrowType = extensionType.deserialize(arrowType, extensionMetadata);
            } else {
                logger.info("Unrecognized extension type: {}", (Object)extensionName);
            }
        }
        DictionaryEncoding dictionaryEncoding = null;
        if (snapshot.dictionary != 0L && provider != null) {
            boolean ordered = (snapshot.flags & 1L) != 0L;
            ArrowType.Int indexType = (ArrowType.Int)arrowType;
            dictionaryEncoding = new DictionaryEncoding(this.nextDictionaryID++, ordered, indexType);
            ArrowSchema dictionarySchema = ArrowSchema.wrap(snapshot.dictionary);
            Field dictionaryField = this.importField(dictionarySchema, provider, recursionLevel + 1);
            provider.put(new Dictionary(dictionaryField.createVector(this.allocator), dictionaryEncoding));
        }
        FieldType fieldType = new FieldType(nullable, arrowType, dictionaryEncoding, metadata);
        ArrayList<Field> children = null;
        long[] childrenIds = NativeUtil.toJavaArray(snapshot.children, LargeMemoryUtil.checkedCastToInt((long)snapshot.n_children));
        if (childrenIds != null && childrenIds.length > 0) {
            children = new ArrayList<Field>(childrenIds.length);
            for (long childAddress : childrenIds) {
                ArrowSchema childSchema = ArrowSchema.wrap(childAddress);
                Field field = this.importField(childSchema, provider, recursionLevel + 1);
                children.add(field);
            }
        }
        return new Field(name, fieldType, children);
    }
}

