/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.arrow.c.ArrowArray;
import org.apache.arrow.c.ArrowArrayStream;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.CDataDictionaryProvider;
import org.apache.arrow.c.Data;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.types.pojo.Schema;

final class ArrowArrayStreamReader
extends ArrowReader {
    private final ArrowArrayStream ownedStream;
    private final CDataDictionaryProvider provider = new CDataDictionaryProvider();

    ArrowArrayStreamReader(BufferAllocator allocator, ArrowArrayStream stream) {
        super(allocator);
        ArrowArrayStream.Snapshot snapshot = stream.snapshot();
        Preconditions.checkState((snapshot.release != 0L ? 1 : 0) != 0, (Object)"Cannot import released ArrowArrayStream");
        this.ownedStream = ArrowArrayStream.allocateNew(allocator);
        this.ownedStream.save(snapshot);
        stream.markReleased();
        stream.close();
    }

    public Map<Long, Dictionary> getDictionaryVectors() {
        return this.provider.getDictionaryIds().stream().collect(Collectors.toMap(Function.identity(), this.provider::lookup));
    }

    public Dictionary lookup(long id) {
        return this.provider.lookup(id);
    }

    public boolean loadNextBatch() throws IOException {
        try (ArrowArray array = ArrowArray.allocateNew(this.allocator);){
            this.ownedStream.getNext(array);
            if (array.snapshot().release == 0L) {
                boolean bl = false;
                return bl;
            }
            Data.importIntoVectorSchemaRoot(this.allocator, array, this.getVectorSchemaRoot(), this.provider);
            boolean bl = true;
            return bl;
        }
    }

    public long bytesRead() {
        return 0L;
    }

    protected void closeReadSource() {
        this.ownedStream.release();
        this.ownedStream.close();
        this.provider.close();
    }

    protected Schema readSchema() throws IOException {
        try (ArrowSchema schema = ArrowSchema.allocateNew(this.allocator);){
            this.ownedStream.getSchema(schema);
            Schema schema2 = Data.importSchema(this.allocator, schema, this.provider);
            return schema2;
        }
    }
}

