/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;

class InsertionSorter {
    InsertionSorter() {
    }

    static <V extends BaseFixedWidthVector> void insertionSort(V vector, int startIdx, int endIdx, VectorValueComparator<V> comparator, V buffer) {
        comparator.attachVectors(vector, buffer);
        for (int i = startIdx; i <= endIdx; ++i) {
            int j;
            buffer.copyFrom(i, 0, vector);
            for (j = i - 1; j >= startIdx && comparator.compare(j, 0) > 0; --j) {
                vector.copyFrom(j, j + 1, vector);
            }
            vector.copyFrom(0, j + 1, buffer);
        }
    }

    static <V extends ValueVector> void insertionSort(IntVector indices, int startIdx, int endIdx, VectorValueComparator<V> comparator) {
        for (int i = startIdx; i <= endIdx; ++i) {
            int j;
            int key = indices.get(i);
            for (j = i - 1; j >= startIdx && comparator.compare(indices.get(j), key) > 0; --j) {
                indices.set(j + 1, indices.get(j));
            }
            indices.set(j + 1, key);
        }
    }
}

