/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.search;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.compare.Range;
import org.apache.arrow.vector.compare.RangeEqualsVisitor;

public class ParallelSearcher<V extends ValueVector> {
    private final V vector;
    private final ExecutorService threadPool;
    private final int numThreads;
    private volatile int keyPosition = -1;

    public ParallelSearcher(V vector, ExecutorService threadPool, int numThreads) {
        this.vector = vector;
        this.threadPool = threadPool;
        this.numThreads = numThreads;
    }

    private CompletableFuture<Boolean>[] initSearch() {
        this.keyPosition = -1;
        CompletableFuture[] futures = new CompletableFuture[this.numThreads];
        for (int i = 0; i < futures.length; ++i) {
            futures[i] = new CompletableFuture();
        }
        return futures;
    }

    public int search(V keyVector, int keyIndex) throws ExecutionException, InterruptedException {
        CompletableFuture[] futures = this.initSearch();
        int valueCount = this.vector.getValueCount();
        int i = 0;
        while (i < this.numThreads) {
            int tid = i++;
            Future<?> future = this.threadPool.submit(() -> {
                int start = (int)((long)valueCount * (long)tid / (long)this.numThreads);
                int end = (int)((long)valueCount) * (tid + 1) / this.numThreads;
                if (start >= end) {
                    futures[tid].complete(false);
                    return;
                }
                RangeEqualsVisitor visitor = new RangeEqualsVisitor(this.vector, keyVector, null);
                Range range = new Range(0, 0, 1);
                for (int pos = start; pos < end; ++pos) {
                    if (this.keyPosition != -1) {
                        futures[tid].complete(false);
                        return;
                    }
                    range.setLeftStart(pos).setRightStart(keyIndex);
                    if (!visitor.rangeEquals(range)) continue;
                    this.keyPosition = pos;
                    futures[tid].complete(true);
                    return;
                }
                futures[tid].complete(false);
            });
        }
        CompletableFuture.allOf(futures).get();
        return this.keyPosition;
    }

    public int search(V keyVector, int keyIndex, VectorValueComparator<V> comparator) throws ExecutionException, InterruptedException {
        CompletableFuture[] futures = this.initSearch();
        int valueCount = this.vector.getValueCount();
        int i = 0;
        while (i < this.numThreads) {
            int tid = i++;
            Future<?> future = this.threadPool.submit(() -> {
                int start = (int)((long)valueCount * (long)tid / (long)this.numThreads);
                int end = (int)((long)valueCount) * (tid + 1) / this.numThreads;
                if (start >= end) {
                    futures[tid].complete(false);
                    return;
                }
                VectorValueComparator<ValueVector> localComparator = comparator.createNew();
                localComparator.attachVectors((ValueVector)this.vector, (ValueVector)keyVector);
                for (int pos = start; pos < end; ++pos) {
                    if (this.keyPosition != -1) {
                        futures[tid].complete(false);
                        return;
                    }
                    if (localComparator.compare(pos, keyIndex) != 0) continue;
                    this.keyPosition = pos;
                    futures[tid].complete(true);
                    return;
                }
                futures[tid].complete(false);
            });
        }
        CompletableFuture.allOf(futures).get();
        return this.keyPosition;
    }
}

