/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.search;

import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.vector.ValueVector;

public class VectorRangeSearcher {
    public static final int SEARCH_FAIL_RESULT = -1;

    public static <V extends ValueVector> int getFirstMatch(V targetVector, VectorValueComparator<V> comparator, V keyVector, int keyIndex) {
        comparator.attachVectors(keyVector, targetVector);
        int ret = -1;
        int low = 0;
        int high = targetVector.getValueCount() - 1;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            int result = comparator.compare(keyIndex, mid);
            if (result < 0) {
                high = mid - 1;
                continue;
            }
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            ret = mid;
            high = mid - 1;
        }
        return ret;
    }

    public static <V extends ValueVector> int getLastMatch(V targetVector, VectorValueComparator<V> comparator, V keyVector, int keyIndex) {
        comparator.attachVectors(keyVector, targetVector);
        int ret = -1;
        int low = 0;
        int high = targetVector.getValueCount() - 1;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            int result = comparator.compare(keyIndex, mid);
            if (result < 0) {
                high = mid - 1;
                continue;
            }
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            ret = mid;
            low = mid + 1;
        }
        return ret;
    }
}

