/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.dictionary;

import java.util.HashMap;
import org.apache.arrow.algorithm.dictionary.DictionaryEncoder;
import org.apache.arrow.memory.util.ArrowBufPointer;
import org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.apache.arrow.memory.util.hash.SimpleHasher;
import org.apache.arrow.vector.BaseIntVector;
import org.apache.arrow.vector.ElementAddressableVector;

public class HashTableDictionaryEncoder<E extends BaseIntVector, D extends ElementAddressableVector>
implements DictionaryEncoder<E, D> {
    private final D dictionary;
    private final ArrowBufHasher hasher;
    private final boolean encodeNull;
    private HashMap<ArrowBufPointer, Integer> hashMap = new HashMap();
    private ArrowBufPointer reusablePointer;

    public HashTableDictionaryEncoder(D dictionary) {
        this(dictionary, false);
    }

    public HashTableDictionaryEncoder(D dictionary, boolean encodeNull) {
        this(dictionary, encodeNull, (ArrowBufHasher)SimpleHasher.INSTANCE);
    }

    public HashTableDictionaryEncoder(D dictionary, boolean encodeNull, ArrowBufHasher hasher) {
        this.dictionary = dictionary;
        this.hasher = hasher;
        this.encodeNull = encodeNull;
        this.reusablePointer = new ArrowBufPointer(hasher);
        this.buildHashMap();
    }

    private void buildHashMap() {
        for (int i = 0; i < this.dictionary.getValueCount(); ++i) {
            ArrowBufPointer pointer = new ArrowBufPointer(this.hasher);
            this.dictionary.getDataPointer(i, pointer);
            this.hashMap.put(pointer, i);
        }
    }

    @Override
    public void encode(D input, E output) {
        for (int i = 0; i < input.getValueCount(); ++i) {
            if (!this.encodeNull && input.isNull(i)) continue;
            input.getDataPointer(i, this.reusablePointer);
            Integer index = this.hashMap.get(this.reusablePointer);
            if (index == null) {
                throw new IllegalArgumentException("The data element is not found in the dictionary");
            }
            output.setWithPossibleTruncate(i, (long)index.intValue());
        }
        output.setValueCount(input.getValueCount());
    }
}

