/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.deduplicate;

import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.compare.Range;
import org.apache.arrow.vector.compare.RangeEqualsVisitor;
import org.apache.arrow.vector.util.DataSizeRoundingUtil;

class DeduplicationUtils {
    DeduplicationUtils() {
    }

    public static <V extends ValueVector> void populateRunStartIndicators(V vector, ArrowBuf runStarts) {
        int bufSize = DataSizeRoundingUtil.divideBy8Ceil((int)vector.getValueCount());
        Preconditions.checkArgument((runStarts.capacity() >= (long)bufSize ? 1 : 0) != 0);
        runStarts.setZero(0L, (long)bufSize);
        BitVectorHelper.setBit((ArrowBuf)runStarts, (long)0L);
        RangeEqualsVisitor visitor = new RangeEqualsVisitor(vector, vector, null);
        Range range = new Range(0, 0, 1);
        for (int i = 1; i < vector.getValueCount(); ++i) {
            range.setLeftStart(i).setRightStart(i - 1);
            if (visitor.rangeEquals(range)) continue;
            BitVectorHelper.setBit((ArrowBuf)runStarts, (long)i);
        }
    }

    public static void populateRunLengths(ArrowBuf runStarts, IntVector runLengths, int valueCount) {
        int curStart = 0;
        int lengthIndex = 0;
        for (int i = 1; i < valueCount; ++i) {
            if (BitVectorHelper.get((ArrowBuf)runStarts, (int)i) == 0) continue;
            runLengths.setSafe(lengthIndex++, i - curStart);
            curStart = i;
        }
        runLengths.setSafe(lengthIndex++, valueCount - curStart);
        runLengths.setValueCount(lengthIndex);
    }

    public static <V extends ValueVector> void populateDeduplicatedValues(ArrowBuf indicators, V inputVector, V outputVector) {
        int dstIdx = 0;
        for (int srcIdx = 0; srcIdx < inputVector.getValueCount(); ++srcIdx) {
            if (BitVectorHelper.get((ArrowBuf)indicators, (int)srcIdx) == 0) continue;
            outputVector.copyFromSafe(srcIdx, dstIdx++, inputVector);
        }
        outputVector.setValueCount(dstIdx);
    }
}

