/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.dictionary;

import org.apache.arrow.vector.BaseIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.compare.Range;
import org.apache.arrow.vector.compare.RangeEqualsVisitor;
import org.apache.arrow.vector.compare.VectorVisitor;

public class LinearDictionaryEncoder<E extends BaseIntVector, D extends ValueVector> {
    private final D dictionary;
    private final boolean encodeNull;
    private RangeEqualsVisitor equalizer;
    private Range range;

    public LinearDictionaryEncoder(D dictionary) {
        this(dictionary, false);
    }

    public LinearDictionaryEncoder(D dictionary, boolean encodeNull) {
        this.dictionary = dictionary;
        this.encodeNull = encodeNull;
        this.equalizer = new RangeEqualsVisitor(dictionary, dictionary, null);
        this.range = new Range(0, 0, 1);
    }

    public void encode(D input, E output) {
        for (int i = 0; i < input.getValueCount(); ++i) {
            if (!this.encodeNull && input.isNull(i)) continue;
            int index = this.linearSearch(input, i);
            if (index == -1) {
                throw new IllegalArgumentException("The data element is not found in the dictionary: " + i);
            }
            output.setWithPossibleTruncate(i, (long)index);
        }
        output.setValueCount(input.getValueCount());
    }

    private int linearSearch(D input, int index) {
        this.range.setLeftStart(index);
        for (int i = 0; i < this.dictionary.getValueCount(); ++i) {
            this.range.setRightStart(i);
            if (!((Boolean)input.accept((VectorVisitor)this.equalizer, (Object)this.range)).booleanValue()) continue;
            return i;
        }
        return -1;
    }
}

