/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.ValueVector;

public class StableVectorComparator<V extends ValueVector>
extends VectorValueComparator<V> {
    private final VectorValueComparator<V> innerComparator;

    public StableVectorComparator(VectorValueComparator<V> innerComparator) {
        this.innerComparator = innerComparator;
    }

    @Override
    public void attachVector(V vector) {
        super.attachVector(vector);
        this.innerComparator.attachVector(vector);
    }

    @Override
    public void attachVectors(V vector1, V vector2) {
        Preconditions.checkArgument((vector1 == vector2 ? 1 : 0) != 0, (Object)"Stable comparator only supports comparing values from the same vector");
        super.attachVectors(vector1, vector2);
        this.innerComparator.attachVectors(vector1, vector2);
    }

    @Override
    public int compareNotNull(int index1, int index2) {
        int result = this.innerComparator.compare(index1, index2);
        return result != 0 ? result : index1 - index2;
    }
}

