/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import java.util.stream.IntStream;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;

public class IndexSorter<V extends ValueVector> {
    private VectorValueComparator<V> comparator;
    private IntVector indices;

    public void sort(V vector, IntVector indices, VectorValueComparator<V> comparator) {
        comparator.attachVector(vector);
        this.indices = indices;
        IntStream.range(0, vector.getValueCount()).forEach(i -> indices.set(i, i));
        this.comparator = comparator;
        this.quickSort(0, indices.getValueCount() - 1);
    }

    private void quickSort(int low, int high) {
        if (low < high) {
            int mid = IndexSorter.partition(low, high, this.indices, this.comparator);
            this.quickSort(low, mid - 1);
            this.quickSort(mid + 1, high);
        }
    }

    public static <T extends ValueVector> int partition(int low, int high, IntVector indices, VectorValueComparator<T> comparator) {
        int pivotIndex = indices.get(low);
        while (low < high) {
            while (low < high && comparator.compare(indices.get(high), pivotIndex) >= 0) {
                --high;
            }
            indices.set(low, indices.get(high));
            while (low < high && comparator.compare(indices.get(low), pivotIndex) <= 0) {
                ++low;
            }
            indices.set(high, indices.get(low));
        }
        indices.set(low, pivotIndex);
        return low;
    }
}

