/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.vector.ValueVector;

public abstract class VectorValueComparator<V extends ValueVector> {
    protected V vector1;
    protected V vector2;
    protected int valueWidth;

    protected VectorValueComparator() {
    }

    protected VectorValueComparator(int valueWidth) {
        this.valueWidth = valueWidth;
    }

    public int getValueWidth() {
        return this.valueWidth;
    }

    public void attachVector(V vector) {
        this.vector1 = vector;
        this.vector2 = vector;
    }

    public void attachVectors(V vector1, V vector2) {
        this.vector1 = vector1;
        this.vector2 = vector2;
    }

    public int compare(int index1, int index2) {
        boolean isNull1 = this.vector1.isNull(index1);
        boolean isNull2 = this.vector2.isNull(index2);
        if (isNull1 || isNull2) {
            if (isNull1 && isNull2) {
                return 0;
            }
            if (isNull1) {
                return -1;
            }
            return 1;
        }
        return this.compareNotNull(index1, index2);
    }

    public abstract int compareNotNull(int var1, int var2);
}

