/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.model.MetadataFacet;
import org.apache.archiva.metadata.model.ProjectMetadata;
import org.apache.archiva.metadata.model.ProjectVersionMetadata;
import org.apache.archiva.metadata.model.ProjectVersionReference;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.MetadataResolutionException;

public interface MetadataRepository {
    public void updateProject(String var1, ProjectMetadata var2) throws MetadataRepositoryException;

    public void updateArtifact(String var1, String var2, String var3, String var4, ArtifactMetadata var5) throws MetadataRepositoryException;

    public void updateProjectVersion(String var1, String var2, String var3, ProjectVersionMetadata var4) throws MetadataRepositoryException;

    public void updateNamespace(String var1, String var2) throws MetadataRepositoryException;

    public List<String> getMetadataFacets(String var1, String var2) throws MetadataRepositoryException;

    public boolean hasMetadataFacet(String var1, String var2) throws MetadataRepositoryException;

    public MetadataFacet getMetadataFacet(String var1, String var2, String var3) throws MetadataRepositoryException;

    public void addMetadataFacet(String var1, MetadataFacet var2) throws MetadataRepositoryException;

    public void removeMetadataFacets(String var1, String var2) throws MetadataRepositoryException;

    public void removeMetadataFacet(String var1, String var2, String var3) throws MetadataRepositoryException;

    public List<ArtifactMetadata> getArtifactsByDateRange(String var1, Date var2, Date var3) throws MetadataRepositoryException;

    public Collection<String> getRepositories() throws MetadataRepositoryException;

    public Collection<ArtifactMetadata> getArtifactsByChecksum(String var1, String var2) throws MetadataRepositoryException;

    public List<ArtifactMetadata> getArtifactsByProjectVersionMetadata(String var1, String var2, String var3) throws MetadataRepositoryException;

    public List<ArtifactMetadata> getArtifactsByMetadata(String var1, String var2, String var3) throws MetadataRepositoryException;

    public List<ArtifactMetadata> getArtifactsByProperty(String var1, String var2, String var3) throws MetadataRepositoryException;

    public void removeArtifact(String var1, String var2, String var3, String var4, String var5) throws MetadataRepositoryException;

    public void removeArtifact(ArtifactMetadata var1, String var2) throws MetadataRepositoryException;

    public void removeArtifact(String var1, String var2, String var3, String var4, MetadataFacet var5) throws MetadataRepositoryException;

    public void removeRepository(String var1) throws MetadataRepositoryException;

    public void removeNamespace(String var1, String var2) throws MetadataRepositoryException;

    public List<ArtifactMetadata> getArtifacts(String var1) throws MetadataRepositoryException;

    public ProjectMetadata getProject(String var1, String var2, String var3) throws MetadataResolutionException;

    public ProjectVersionMetadata getProjectVersion(String var1, String var2, String var3, String var4) throws MetadataResolutionException;

    public Collection<String> getArtifactVersions(String var1, String var2, String var3, String var4) throws MetadataResolutionException;

    public Collection<ProjectVersionReference> getProjectReferences(String var1, String var2, String var3, String var4) throws MetadataResolutionException;

    public Collection<String> getRootNamespaces(String var1) throws MetadataResolutionException;

    public Collection<String> getNamespaces(String var1, String var2) throws MetadataResolutionException;

    public Collection<String> getProjects(String var1, String var2) throws MetadataResolutionException;

    public Collection<String> getProjectVersions(String var1, String var2, String var3) throws MetadataResolutionException;

    public void removeProjectVersion(String var1, String var2, String var3, String var4) throws MetadataRepositoryException;

    public Collection<ArtifactMetadata> getArtifacts(String var1, String var2, String var3, String var4) throws MetadataResolutionException;

    public void removeProject(String var1, String var2, String var3) throws MetadataRepositoryException;

    public void save();

    public void close() throws MetadataRepositoryException;

    public void revert();

    public boolean canObtainAccess(Class<?> var1);

    public <T> T obtainAccess(Class<T> var1) throws MetadataRepositoryException;

    public List<ArtifactMetadata> searchArtifacts(String var1, String var2, boolean var3) throws MetadataRepositoryException;

    public List<ArtifactMetadata> searchArtifacts(String var1, String var2, String var3, boolean var4) throws MetadataRepositoryException;
}

