/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.plugin.crawler;

import edu.uci.ics.crawler4j.crawler.Page;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.any23.plugin.crawler.CrawlerListener;

public class SharedData {
    private static SharedData instance;
    private final String seed;
    private final Pattern pattern;
    private final List<CrawlerListener> listeners;

    protected static SharedData getInstance() {
        if (instance == null) {
            throw new IllegalStateException("The configuration has not yet initialized.");
        }
        return instance;
    }

    protected static void setCrawlData(String seed, Pattern regex, List<CrawlerListener> listeners) {
        instance = new SharedData(seed, regex, listeners);
    }

    private SharedData(String seed, Pattern pattern, List<CrawlerListener> listeners) {
        if (seed == null || seed.trim().length() == 0) {
            throw new IllegalArgumentException(String.format("Invalid seed '%s'", seed));
        }
        this.seed = seed;
        this.pattern = pattern;
        this.listeners = listeners;
    }

    protected String getSeed() {
        return this.seed;
    }

    protected Pattern getPattern() {
        return this.pattern;
    }

    protected void notifyPage(Page page) {
        for (CrawlerListener listener : this.listeners) {
            listener.visitedPage(page);
        }
    }
}

