/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.cli;

import java.io.File;
import org.apache.any23.cli.Rover;
import org.apache.any23.cli.ToolTestBase;
import org.apache.any23.rdf.RDFUtils;
import org.apache.any23.util.FileUtils;
import org.apache.any23.util.StringUtils;
import org.apache.any23.util.URLUtils;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class RoverTest
extends ToolTestBase {
    private static final String[] TARGET_FILES = new String[]{"/microdata/microdata-nested.html", "/org/apache/any23/extractor/csv/test-semicolon.csv"};
    private static final String[] TARGET_URLS = new String[]{"http://twitter.com/micmos", "http://twitter.com/dpalmisano"};

    public RoverTest() {
        super(Rover.class);
    }

    @Test
    public void testRunMultiFiles() throws Exception {
        String[] copiedTargets = new String[TARGET_FILES.length];
        for (int i = 0; i < TARGET_FILES.length; ++i) {
            File tempFile = this.copyResourceToTempFile(TARGET_FILES[i]);
            copiedTargets[i] = tempFile.getAbsolutePath();
        }
        this.runWithMultiSourcesAndVerify(copiedTargets, 0);
    }

    @Test
    public void testRunWithDefaultNS() throws Exception {
        String DEFAULT_GRAPH = "http://test/default/ns";
        File outFile = File.createTempFile("rover-test", "out", this.tempDirectory);
        int exitCode = this.runTool(String.format("-o %s -f nquads -p -n %s -d %s", outFile.getAbsolutePath(), this.copyResourceToTempFile("/cli/rover-test1.nq").getAbsolutePath(), "http://test/default/ns"));
        Assert.assertEquals((String)"Unexpected exit code.", (long)0L, (long)exitCode);
        Assert.assertTrue((boolean)outFile.exists());
        String fileContent = FileUtils.readFileContent((File)outFile);
        String[] lines = fileContent.split("\\n");
        int graphCounter = 0;
        for (String line : lines) {
            if (!line.contains("http://test/default/ns")) continue;
            ++graphCounter;
        }
        Assert.assertEquals((long)0L, (long)graphCounter);
    }

    @Test
    public void testDelegatingWriterFactory() throws Exception {
        File outFile = File.createTempFile("rover-test", "out", this.tempDirectory);
        String DEFAULT_GRAPH = "http://test/default/ns";
        String stylesheet = "http://www.w3.org/1999/xhtml/vocab#stylesheet";
        Assert.assertEquals((String)"Unexpected exit code.", (long)0L, (long)this.runTool(String.format("-o %s -f nquads %s -d %s", outFile.getAbsolutePath(), this.copyResourceToTempFile("/cli/basic-with-stylesheet.html").getAbsolutePath(), "http://test/default/ns")));
        String content = FileUtils.readFileContent((File)outFile);
        Assert.assertTrue((boolean)content.contains("http://www.w3.org/1999/xhtml/vocab#stylesheet"));
        int lineCountWithStylesheet = content.split("\\n").length;
        Assert.assertEquals((String)"Unexpected exit code.", (long)0L, (long)this.runTool(String.format("-o %s -f notrivial,nquads %s -d %s", outFile.getAbsolutePath(), this.copyResourceToTempFile("/cli/basic-with-stylesheet.html").getAbsolutePath(), "http://test/default/ns")));
        content = FileUtils.readFileContent((File)outFile);
        Assert.assertTrue((!content.contains("http://www.w3.org/1999/xhtml/vocab#stylesheet") ? 1 : 0) != 0);
        int lineCountWithoutStylesheet = content.split("\\n").length;
        Assert.assertEquals((long)(lineCountWithStylesheet - 1), (long)lineCountWithoutStylesheet);
    }

    @Test
    public void testRunMultiURLs() throws Exception {
        RoverTest.assumeOnlineAllowed();
        for (String targetURL : TARGET_URLS) {
            Assume.assumeTrue((boolean)URLUtils.isOnline((String)targetURL));
        }
        this.runWithMultiSourcesAndVerify(TARGET_URLS, 0);
    }

    private void runWithMultiSourcesAndVerify(String[] targets, int expectedExit) throws Exception {
        File outFile = File.createTempFile("rover-test", "out", this.tempDirectory);
        File logFile = File.createTempFile("rover-test", "log", this.tempDirectory);
        int exitCode = this.runTool(String.format("-o %s -f nquads -l %s -p -n %s", outFile.getAbsolutePath(), logFile.getAbsolutePath(), StringUtils.join((String)" ", (String[])targets)));
        Assert.assertEquals((String)"Unexpected exit code.", (long)expectedExit, (long)exitCode);
        Assert.assertTrue((boolean)outFile.exists());
        Assert.assertTrue((boolean)logFile.exists());
        String logFileContent = FileUtils.readFileContent((File)logFile);
        Assert.assertEquals((String)"Unexpected number of log lines.", (long)(targets.length + 1), (long)StringUtils.countNL((String)logFileContent));
        String outNQuads = FileUtils.readFileContent((File)outFile);
        Statement[] statements = RDFUtils.parseRDF((RDFFormat)RDFFormat.NQUADS, (String)outNQuads);
        Assert.assertTrue((String)"Unexpected number of statements.", (statements.length > 9 ? 1 : 0) != 0);
    }
}

