/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool.reports;

import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.activemq.tool.reports.AbstractPerfReportWriter;

public class VerbosePerfReportWriter
extends AbstractPerfReportWriter {
    public void openReportWriter() {
    }

    public void closeReportWriter() {
        this.writeHeader("Performance Summary");
        this.writePerfSummary();
    }

    public void writeInfo(String info) {
        System.out.println("[PERF-INFO]: " + info);
    }

    public void writeCsvData(int csvType, String csvData) {
        if (csvType == 0) {
            System.out.println("[PERF-TP]: " + csvData);
        } else if (csvType == 1) {
            System.out.println("[PERF-CPU]: " + csvData);
        }
        this.handleCsvData(csvType, csvData);
    }

    public void writeProperties(String header, Properties props) {
        this.writeHeader(header);
        this.writeProperties(props);
    }

    public void writeProperties(Properties props) {
        for (String string : props.keySet()) {
            String val = props.getProperty(string, "");
            System.out.println("[PERF-PROP]: " + string + "=" + val);
        }
    }

    public void writePerfSummary() {
        Map summary = this.getSummary(0);
        if (summary != null && summary.size() > 0) {
            this.writeThroughputSummary(summary);
        }
        if ((summary = this.getSummary(1)) != null && summary.size() > 0) {
            this.writeCpuSummary(summary);
        }
    }

    protected void writeThroughputSummary(Map summary) {
        this.writeHeader("SYSTEM THROUGHPUT SUMMARY");
        System.out.println("[PERF-TP-SUMMARY] System Total Throughput: " + summary.get("SystemTotalTP"));
        System.out.println("[PERF-TP-SUMMARY] System Total Clients: " + summary.get("SystemTotalClients"));
        System.out.println("[PERF-TP-SUMMARY] System Average Throughput: " + summary.get("SystemAveTP"));
        System.out.println("[PERF-TP-SUMMARY] System Average Throughput Excluding Min/Max: " + summary.get("SystemAveEMMTP"));
        System.out.println("[PERF-TP-SUMMARY] System Average Client Throughput: " + summary.get("SystemAveClientTP"));
        System.out.println("[PERF-TP-SUMMARY] System Average Client Throughput Excluding Min/Max: " + summary.get("SystemAveClientEMMTP"));
        System.out.println("[PERF-TP-SUMMARY] Min Client Throughput Per Sample: " + summary.get("MinClientTP"));
        System.out.println("[PERF-TP-SUMMARY] Max Client Throughput Per Sample: " + summary.get("MaxClientTP"));
        System.out.println("[PERF-TP-SUMMARY] Min Client Total Throughput: " + summary.get("MinClientTotalTP"));
        System.out.println("[PERF-TP-SUMMARY] Max Client Total Throughput: " + summary.get("MaxClientTotalTP"));
        System.out.println("[PERF-TP-SUMMARY] Min Client Average Throughput: " + summary.get("MinClientAveTP"));
        System.out.println("[PERF-TP-SUMMARY] Max Client Average Throughput: " + summary.get("MaxClientAveTP"));
        System.out.println("[PERF-TP-SUMMARY] Min Client Average Throughput Excluding Min/Max: " + summary.get("MinClientAveEMMTP"));
        System.out.println("[PERF-TP-SUMMARY] Max Client Average Throughput Excluding Min/Max: " + summary.get("MaxClientAveEMMTP"));
    }

    protected void writeCpuSummary(Map summary) {
        this.writeHeader("SYSTEM CPU USAGE SUMMARY");
        System.out.println("[PERF-CPU-SUMMARY] Total Blocks Received: " + summary.get("BlocksReceived"));
        System.out.println("[PERF-CPU-SUMMARY] Ave Blocks Received: " + summary.get("AveBlocksReceived"));
        System.out.println("[PERF-CPU-SUMMARY] Total Blocks Sent: " + summary.get("BlocksSent"));
        System.out.println("[PERF-CPU-SUMMARY] Ave Blocks Sent: " + summary.get("AveBlocksSent"));
        System.out.println("[PERF-CPU-SUMMARY] Total Context Switches: " + summary.get("ContextSwitches"));
        System.out.println("[PERF-CPU-SUMMARY] Ave Context Switches: " + summary.get("AveContextSwitches"));
        System.out.println("[PERF-CPU-SUMMARY] Total User Time: " + summary.get("UserTime"));
        System.out.println("[PERF-CPU-SUMMARY] Ave User Time: " + summary.get("AveUserTime"));
        System.out.println("[PERF-CPU-SUMMARY] Total System Time: " + summary.get("SystemTime"));
        System.out.println("[PERF-CPU-SUMMARY] Ave System Time: " + summary.get("AveSystemTime"));
        System.out.println("[PERF-CPU-SUMMARY] Total Idle Time: " + summary.get("IdleTime"));
        System.out.println("[PERF-CPU-SUMMARY] Ave Idle Time: " + summary.get("AveIdleTime"));
        System.out.println("[PERF-CPU-SUMMARY] Total Wait Time: " + summary.get("WaitingTime"));
        System.out.println("[PERF-CPU-SUMMARY] Ave Wait Time: " + summary.get("AveWaitingTime"));
    }

    protected void writeHeader(String header) {
        char[] border = new char[header.length() + 8];
        Arrays.fill(border, '#');
        String borderStr = new String(border);
        System.out.println(borderStr);
        System.out.println("#   " + header + "   #");
        System.out.println(borderStr);
    }
}

