/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool.reports;

import java.util.Iterator;
import java.util.List;

public final class PerformanceStatisticsUtil {
    private PerformanceStatisticsUtil() {
    }

    public static long getSum(List numList) {
        long sum = 0L;
        if (numList != null) {
            Iterator i = numList.iterator();
            while (i.hasNext()) {
                sum += ((Long)i.next()).longValue();
            }
        } else {
            sum = -1L;
        }
        return sum;
    }

    public static long getMin(List numList) {
        long min = Long.MAX_VALUE;
        if (numList != null) {
            Iterator i = numList.iterator();
            while (i.hasNext()) {
                min = Math.min((Long)i.next(), min);
            }
        } else {
            min = -1L;
        }
        return min;
    }

    public static long getMax(List numList) {
        long max = Long.MIN_VALUE;
        if (numList != null) {
            Iterator i = numList.iterator();
            while (i.hasNext()) {
                max = Math.max((Long)i.next(), max);
            }
        } else {
            max = -1L;
        }
        return max;
    }

    public static double getAve(List numList) {
        if (numList != null) {
            int sampleCount = 0;
            long totalTP = 0L;
            Iterator i = numList.iterator();
            while (i.hasNext()) {
                ++sampleCount;
                totalTP += ((Long)i.next()).longValue();
            }
            return (double)totalTP / (double)sampleCount;
        }
        double ave = -1.0;
        return ave;
    }

    public static double getAveEx(List numList) {
        long minTP = PerformanceStatisticsUtil.getMin(numList);
        long maxTP = PerformanceStatisticsUtil.getMax(numList);
        if (numList != null) {
            int sampleCount = 0;
            long totalTP = 0L;
            Iterator i = numList.iterator();
            while (i.hasNext()) {
                ++sampleCount;
                long sampleTP = (Long)i.next();
                if (sampleTP == minTP || sampleTP == maxTP) continue;
                totalTP += sampleTP;
            }
            return (double)totalTP / (double)sampleCount;
        }
        double ave = -1.0;
        return ave;
    }
}

