/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.tool.properties.JmsClientProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractJmsClient {
    private static final Log LOG = LogFactory.getLog(AbstractJmsClient.class);
    protected ConnectionFactory factory;
    protected Connection jmsConnection;
    protected Session jmsSession;
    protected int destCount = 1;
    protected int destIndex;
    protected String clientName = "";

    public AbstractJmsClient(ConnectionFactory factory) {
        this.factory = factory;
    }

    public abstract JmsClientProperties getClient();

    public abstract void setClient(JmsClientProperties var1);

    public ConnectionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ConnectionFactory factory) {
        this.factory = factory;
    }

    public int getDestCount() {
        return this.destCount;
    }

    public void setDestCount(int destCount) {
        this.destCount = destCount;
    }

    public int getDestIndex() {
        return this.destIndex;
    }

    public void setDestIndex(int destIndex) {
        this.destIndex = destIndex;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public Connection getConnection() throws JMSException {
        if (this.jmsConnection == null) {
            this.jmsConnection = this.factory.createConnection();
            this.jmsConnection.setClientID(this.getClientName());
            LOG.info((Object)("Creating JMS Connection: Provider=" + this.getClient().getJmsProvider() + ", JMS Spec=" + this.getClient().getJmsVersion()));
        }
        return this.jmsConnection;
    }

    public Session getSession() throws JMSException {
        if (this.jmsSession == null) {
            int ackMode = this.getClient().getSessAckMode().equalsIgnoreCase("autoAck") ? 1 : (this.getClient().getSessAckMode().equalsIgnoreCase("clientAck") ? 2 : (this.getClient().getSessAckMode().equalsIgnoreCase("dupsAck") ? 3 : (this.getClient().getSessAckMode().equalsIgnoreCase("transacted") ? 0 : 1)));
            this.jmsSession = this.getConnection().createSession(this.getClient().isSessTransacted(), ackMode);
        }
        return this.jmsSession;
    }

    public Destination[] createDestination(int destIndex, int destCount) throws JMSException {
        if (this.getClient().isDestComposite()) {
            return new Destination[]{this.createCompositeDestination(this.getClient().getDestName(), destIndex, destCount)};
        }
        Destination[] dest = new Destination[destCount];
        for (int i = 0; i < destCount; ++i) {
            dest[i] = this.createDestination(this.getClient().getDestName() + "." + (destIndex + i));
        }
        return dest;
    }

    public Destination createCompositeDestination(int destIndex, int destCount) throws JMSException {
        return this.createCompositeDestination(this.getClient().getDestName(), destIndex, destCount);
    }

    protected Destination createCompositeDestination(String name, int destIndex, int destCount) throws JMSException {
        int i;
        String simpleName = name.startsWith("queue://") ? name.substring("queue://".length()) : (name.startsWith("topic://") ? name.substring("topic://".length()) : name);
        String compDestName = name + "." + destIndex + ",";
        for (i = 1; i < destCount - 1; ++i) {
            compDestName = compDestName + simpleName + "." + (destIndex + i) + ",";
        }
        compDestName = compDestName + simpleName + "." + (destIndex + i);
        return this.createDestination(compDestName);
    }

    protected Destination createDestination(String name) throws JMSException {
        if (name.startsWith("queue://")) {
            return this.getSession().createQueue(name.substring("queue://".length()));
        }
        if (name.startsWith("topic://")) {
            return this.getSession().createTopic(name.substring("topic://".length()));
        }
        return this.getSession().createTopic(name);
    }
}

