/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool.spi;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.ConnectionFactory;
import org.apache.activemq.tool.spi.SPIConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ClassLoaderSPIConnectionFactory
implements SPIConnectionFactory {
    private static final Log log = LogFactory.getLog((Class)ClassLoaderSPIConnectionFactory.class);
    public static final String KEY_EXT_DIR = "extDir";

    public final ConnectionFactory createConnectionFactory(Properties settings) throws Exception {
        ClassLoader newClassLoader = this.getContextClassLoader(settings);
        Thread.currentThread().setContextClassLoader(newClassLoader);
        return this.instantiateConnectionFactory(settings);
    }

    protected ClassLoader getContextClassLoader(Properties settings) {
        String extDir = (String)settings.remove(KEY_EXT_DIR);
        if (extDir != null) {
            StringTokenizer tokens = new StringTokenizer(extDir, ";,");
            ArrayList<URL> urls = new ArrayList<URL>();
            while (tokens.hasMoreTokens()) {
                String dir = tokens.nextToken();
                try {
                    File f = new File(dir);
                    if (!f.exists()) {
                        log.warn((Object)("Cannot find extension dir: " + f.getAbsolutePath()));
                        continue;
                    }
                    log.info((Object)("Adding extension dir: " + f.getAbsolutePath()));
                    urls.add(f.toURL());
                    File[] files = f.listFiles();
                    if (files == null) continue;
                    for (int j = 0; j < files.length; ++j) {
                        if (!files[j].getName().endsWith(".zip") && !files[j].getName().endsWith(".jar")) continue;
                        log.info((Object)("Adding extension dir: " + files[j].getAbsolutePath()));
                        urls.add(files[j].toURL());
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to load ext dir: " + dir + ". Reason: " + e));
                }
            }
            URL[] u = new URL[urls.size()];
            urls.toArray(u);
            return new URLClassLoader(u, Thread.currentThread().getContextClassLoader());
        }
        return ClassLoaderSPIConnectionFactory.class.getClassLoader();
    }

    protected abstract ConnectionFactory instantiateConnectionFactory(Properties var1) throws Exception;
}

