/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.apache.activemq.console.Main;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class ServerMojo
extends AbstractMojo {
    private File outputDirectory;
    private String configDirectory;
    private String configType;
    private File configFile;
    private String url;

    public void execute() throws MojoExecutionException {
        File out = this.outputDirectory;
        if (!out.exists()) {
            out.mkdirs();
        }
        String[] args = new String[2];
        if (this.url != null) {
            args[0] = "start";
            args[1] = this.url;
        } else {
            File config = this.configFile != null ? this.configFile : new File(this.configDirectory + File.separator + this.configType + ".xml");
            try {
                config = this.copy(config);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage());
            }
            args[0] = "start";
            args[1] = "xbean:" + config.toURI().toString();
        }
        this.getLog().info((CharSequence)("Starting broker with configuration in:  " + args[1]));
        Main.main((String[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File copy(File source) throws IOException {
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        File dest = new File(this.outputDirectory.getAbsolutePath() + File.separator + "activemq.xml");
        try {
            in = new FileInputStream(source).getChannel();
            out = new FileOutputStream(dest).getChannel();
            long size = in.size();
            MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            ((FileChannel)out).write(buf);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return dest;
    }
}

