/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.maven;

import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.maven.plugin.MojoExecutionException;

public class Broker {
    private static BrokerService broker;
    private static boolean[] shutdown;
    private static Thread shutdownThread;

    public static void start(boolean fork, String configUri) throws MojoExecutionException {
        if (broker != null) {
            throw new MojoExecutionException("A local broker is already running");
        }
        try {
            broker = BrokerFactory.createBroker((String)configUri);
            if (fork) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            broker.start();
                            Broker.waitForShutdown();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
            } else {
                broker.start();
                Broker.waitForShutdown();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to start the ActiveMQ Broker", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() throws MojoExecutionException {
        if (broker == null) {
            throw new MojoExecutionException("The local broker is not running");
        }
        try {
            broker.stop();
            broker.waitUntilStopped();
            broker = null;
            Runtime.getRuntime().removeShutdownHook(shutdownThread);
            boolean[] blArray = shutdown;
            synchronized (shutdown) {
                Broker.shutdown[0] = true;
                shutdown.notify();
                // ** MonitorExit[var0] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to stop the ActiveMQ Broker", e);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void waitForShutdown() throws Exception {
        shutdown = new boolean[]{false};
        shutdownThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean[] blArray = shutdown;
                synchronized (shutdown) {
                    Broker.shutdown[0] = true;
                    shutdown.notify();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        boolean[] blArray = shutdown;
        synchronized (shutdown) {
            while (!shutdown[0]) {
                try {
                    shutdown.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            if (broker != null) {
                broker.stop();
            }
            return;
        }
    }

    public static BrokerService getBroker() {
        return broker;
    }

    public static void setBroker(BrokerService broker) {
        Broker.broker = broker;
    }
}

