/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.component;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.ActiveMQWebLogger;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.component.AuthenticationFilter;
import org.apache.activemq.artemis.component.DefaultHandler;
import org.apache.activemq.artemis.component.JolokiaFilter;
import org.apache.activemq.artemis.components.ExternalComponent;
import org.apache.activemq.artemis.core.remoting.impl.ssl.SSLSupport;
import org.apache.activemq.artemis.dto.AppDTO;
import org.apache.activemq.artemis.dto.BindingDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.dto.WebServerDTO;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.marker.WebServerComponentMarker;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.apache.activemq.artemis.utils.PemConfigUtil;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.ee9.security.Authenticator;
import org.eclipse.jetty.ee9.security.DefaultAuthenticatorFactory;
import org.eclipse.jetty.ee9.servlet.FilterHolder;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServerComponent
implements ExternalComponent,
WebServerComponentMarker {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String WEB_CONSOLE_DISPLAY_NAME = System.getProperty("org.apache.activemq.artemis.webConsoleDisplayName", "Artemis Console");
    public static final boolean DEFAULT_SNI_HOST_CHECK_VALUE = true;
    public static final boolean DEFAULT_SNI_REQUIRED_VALUE = false;
    public static final boolean DEFAULT_SSL_AUTO_RELOAD_VALUE = false;
    public static final int DEFAULT_SCAN_PERIOD_VALUE = 5;
    private Server server;
    private Handler.Sequence handlers;
    private WebServerDTO webServerConfig;
    private final List<String> consoleUrls = new ArrayList<String>();
    private final List<String> jolokiaUrls = new ArrayList<String>();
    private final List<Pair<WebAppContext, String>> webContextData = new ArrayList<Pair<WebAppContext, String>>();
    private ServerConnector[] connectors;
    private Path artemisHomePath;
    private Path temporaryWarDir;
    private String artemisInstance;
    private String artemisHome;
    private int scanPeriod;
    private Scanner scanner;
    private ScheduledExecutorScheduler scannerScheduler;
    private Map<String, List<Runnable>> scannerTasks = new HashMap<String, List<Runnable>>();
    private LinkOption[] scannerLinkOptions = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};

    public void configure(ComponentDTO config, String artemisInstance, String artemisHome) throws Exception {
        this.webServerConfig = (WebServerDTO)config;
        this.artemisInstance = artemisInstance;
        this.artemisHome = artemisHome;
        this.scanPeriod = this.webServerConfig.getScanPeriod() != null ? this.webServerConfig.getScanPeriod() : 5;
        this.temporaryWarDir = Paths.get(artemisInstance != null ? artemisInstance : ".", new String[0]).resolve("tmp").resolve("webapps").toAbsolutePath();
        if (!Files.exists(this.temporaryWarDir, new LinkOption[0])) {
            Files.createDirectories(this.temporaryWarDir, new FileAttribute[0]);
        }
    }

    public synchronized void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        ActiveMQWebLogger.LOGGER.startingEmbeddedWebServer();
        this.server = new Server((ThreadPool)new QueuedThreadPool(this.webServerConfig.maxThreads.intValue(), this.webServerConfig.minThreads.intValue(), this.webServerConfig.idleThreadTimeout.intValue()));
        this.handlers = new Handler.Sequence(new Handler[0]);
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        if (this.webServerConfig.maxRequestHeaderSize != null) {
            httpConfiguration.setRequestHeaderSize(this.webServerConfig.maxRequestHeaderSize.intValue());
        }
        if (this.webServerConfig.maxResponseHeaderSize != null) {
            httpConfiguration.setResponseHeaderSize(this.webServerConfig.maxResponseHeaderSize.intValue());
        }
        if (this.webServerConfig.customizer != null) {
            try {
                httpConfiguration.addCustomizer((HttpConfiguration.Customizer)ClassloadingUtil.getInstanceWithTypeCheck((String)this.webServerConfig.customizer, HttpConfiguration.Customizer.class, (ClassLoader)this.getClass().getClassLoader()));
            }
            catch (Throwable t) {
                ActiveMQWebLogger.LOGGER.customizerNotLoaded(this.webServerConfig.customizer, t);
            }
        }
        List bindings = this.webServerConfig.getAllBindings();
        this.connectors = new ServerConnector[bindings.size()];
        String[] virtualHosts = new String[bindings.size()];
        this.artemisHomePath = Paths.get(this.artemisHome != null ? this.artemisHome : ".", new String[0]);
        Path homeWarDir = this.artemisHomePath.resolve(this.webServerConfig.path).toAbsolutePath();
        Path instanceWarDir = Paths.get(this.artemisInstance != null ? this.artemisInstance : ".", new String[0]).resolve(this.webServerConfig.path).toAbsolutePath();
        for (int i = 0; i < bindings.size(); ++i) {
            ServerConnector connector;
            BindingDTO binding = (BindingDTO)bindings.get(i);
            URI uri = new URI(binding.uri);
            String scheme = uri.getScheme();
            this.connectors[i] = connector = this.createServerConnector(httpConfiguration, i, binding, uri, scheme);
            virtualHosts[i] = "@Connector-" + i;
            if (binding.apps == null || binding.apps.isEmpty()) continue;
            for (AppDTO app : binding.apps) {
                Path dirToUse = homeWarDir;
                if (new File(String.valueOf(instanceWarDir.toFile()) + File.separator + app.war).exists()) {
                    dirToUse = instanceWarDir;
                }
                WebAppContext webContext = this.createWebAppContext(app.url, app.war, dirToUse, virtualHosts[i]);
                this.handlers.addHandler((Supplier)webContext);
                webContext.getSessionHandler().getSessionCookieConfig().setComment("__SAME_SITE_STRICT__");
                webContext.addEventListener((EventListener)new ServletContextListener(){

                    public void contextInitialized(ServletContextEvent sce) {
                        sce.getServletContext().addListener((EventListener)new ServletRequestListener(){

                            public void requestDestroyed(ServletRequestEvent sre) {
                                super.requestDestroyed(sre);
                                AuditLogger.currentCaller.remove();
                                AuditLogger.remoteAddress.remove();
                            }
                        });
                    }
                });
                this.webContextData.add((Pair<WebAppContext, String>)new Pair((Object)webContext, (Object)binding.uri));
            }
        }
        this.server.setConnectors((Connector[])this.connectors);
        ResourceHandler homeResourceHandler = new ResourceHandler();
        homeResourceHandler.setDirAllowed(false);
        homeResourceHandler.setWelcomeFiles(new String[]{"index.html"});
        ContextHandler homeContext = new ContextHandler();
        homeContext.setContextPath("/");
        homeContext.setBaseResourceAsPath(homeWarDir);
        homeContext.setHandler((Handler)homeResourceHandler);
        homeContext.setVirtualHosts(Arrays.asList(virtualHosts));
        ResourceHandler instanceResourceHandler = new ResourceHandler();
        instanceResourceHandler.setDirAllowed(false);
        instanceResourceHandler.setWelcomeFiles(new String[]{"index.html"});
        ContextHandler instanceContext = new ContextHandler();
        instanceContext.setContextPath("/");
        instanceContext.setBaseResourceAsPath(instanceWarDir);
        instanceContext.setHandler((Handler)instanceResourceHandler);
        instanceContext.setVirtualHosts(Arrays.asList(virtualHosts));
        DefaultHandler defaultHandler = new DefaultHandler();
        defaultHandler.setServeFavIcon(false);
        defaultHandler.setRootRedirectLocation(this.webServerConfig.rootRedirectLocation);
        if (this.webServerConfig.requestLog != null && this.webServerConfig.requestLog.filename != null) {
            this.server.setRequestLog(this.getRequestLog());
        }
        if (this.webServerConfig.webContentEnabled != null && this.webServerConfig.webContentEnabled.booleanValue()) {
            this.handlers.addHandler((Handler)homeContext);
            this.handlers.addHandler((Handler)instanceContext);
        }
        this.handlers.addHandler((Handler)defaultHandler);
        this.server.setHandler((Handler)this.handlers);
        this.server.start();
        this.printStatus(bindings);
    }

    private void printStatus(List<BindingDTO> bindings) {
        ActiveMQWebLogger.LOGGER.webserverStarted(bindings.stream().map(binding -> binding.uri).collect(Collectors.joining(", ")));
        for (Pair<WebAppContext, String> data : this.webContextData) {
            if (!WEB_CONSOLE_DISPLAY_NAME.equals(((WebAppContext)data.getA()).getDisplayName())) continue;
            this.consoleUrls.add((String)data.getB() + ((WebAppContext)data.getA()).getContextPath());
            this.jolokiaUrls.add((String)data.getB() + ((WebAppContext)data.getA()).getContextPath() + "/jolokia");
        }
        if (!this.jolokiaUrls.isEmpty()) {
            ActiveMQWebLogger.LOGGER.jolokiaAvailable(String.join((CharSequence)", ", this.jolokiaUrls));
        }
        if (!this.consoleUrls.isEmpty()) {
            ActiveMQWebLogger.LOGGER.consoleAvailable(String.join((CharSequence)", ", this.consoleUrls));
        }
    }

    private ServerConnector createServerConnector(HttpConfiguration httpConfiguration, int i, BindingDTO binding, URI uri, String scheme) throws Exception {
        ServerConnector connector;
        if ("https".equals(scheme)) {
            SslContextFactory.Server sslFactory = new SslContextFactory.Server();
            sslFactory.setKeyStorePath((String)(binding.keyStorePath == null ? this.artemisInstance + "/etc/keystore.jks" : binding.keyStorePath));
            if (binding.keyStoreType != null) {
                sslFactory.setKeyStoreType(binding.keyStoreType);
                SSLSupport.checkPemProviderLoaded((String)binding.keyStoreType);
            }
            sslFactory.setKeyStorePassword(binding.getKeyStorePassword() == null ? "password" : binding.getKeyStorePassword());
            if (binding.getIncludedTLSProtocols() != null) {
                sslFactory.setIncludeProtocols(binding.getIncludedTLSProtocols());
            }
            if (binding.getExcludedTLSProtocols() != null) {
                sslFactory.setExcludeProtocols(binding.getExcludedTLSProtocols());
            }
            if (binding.getIncludedCipherSuites() != null) {
                sslFactory.setIncludeCipherSuites(binding.getIncludedCipherSuites());
            }
            if (binding.getExcludedCipherSuites() != null) {
                sslFactory.setExcludeCipherSuites(binding.getExcludedCipherSuites());
            }
            if (binding.clientAuth != null) {
                sslFactory.setNeedClientAuth(binding.clientAuth.booleanValue());
                if (binding.clientAuth.booleanValue()) {
                    sslFactory.setTrustStorePath(binding.trustStorePath);
                    sslFactory.setTrustStorePassword(binding.getTrustStorePassword());
                    if (binding.trustStoreType != null) {
                        sslFactory.setTrustStoreType(binding.trustStoreType);
                        SSLSupport.checkPemProviderLoaded((String)binding.trustStoreType);
                    }
                }
            }
            if (Boolean.TRUE.equals(binding.getSslAutoReload())) {
                this.addStoreResourceScannerTask(binding.getKeyStorePath(), binding.getKeyStoreType(), sslFactory);
                this.addStoreResourceScannerTask(binding.getTrustStorePath(), binding.getTrustStoreType(), sslFactory);
            }
            SecureRequestCustomizer secureRequestCustomizer = new SecureRequestCustomizer();
            secureRequestCustomizer.setSniHostCheck(binding.getSniHostCheck() != null ? binding.getSniHostCheck() : true);
            secureRequestCustomizer.setSniRequired(binding.getSniRequired() != null ? binding.getSniRequired() : false);
            httpConfiguration.addCustomizer((HttpConfiguration.Customizer)secureRequestCustomizer);
            httpConfiguration.setSendServerVersion(false);
            HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpConfiguration);
            HTTP2ServerConnectionFactory h2 = new HTTP2ServerConnectionFactory(httpConfiguration);
            ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
            alpn.setDefaultProtocol(HttpVersion.HTTP_1_1.asString());
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslFactory, alpn.getProtocol());
            connector = new ServerConnector(this.server, new ConnectionFactory[]{sslConnectionFactory, alpn, h2, httpFactory});
        } else {
            httpConfiguration.setSendServerVersion(false);
            HttpConnectionFactory connectionFactory = new HttpConnectionFactory(httpConfiguration);
            connector = new ServerConnector(this.server, new ConnectionFactory[]{connectionFactory});
        }
        connector.setPort(uri.getPort());
        connector.setHost(uri.getHost());
        connector.setName("Connector-" + i);
        return connector;
    }

    private File getStoreFile(String storeFilename) {
        File storeFile = new File(storeFilename);
        if (!storeFile.exists()) {
            throw new IllegalArgumentException("Store file does not exist: " + storeFilename);
        }
        if (storeFile.isDirectory()) {
            throw new IllegalArgumentException("Expected store file not directory: " + storeFilename);
        }
        return storeFile;
    }

    private File getParentStoreFile(File storeFile) {
        File parentFile = storeFile.getParentFile();
        if (!parentFile.exists() || !parentFile.isDirectory()) {
            throw new IllegalArgumentException("Error obtaining store dir for " + String.valueOf(storeFile));
        }
        return parentFile;
    }

    private Scanner getScanner() {
        if (this.scannerScheduler == null) {
            this.scannerScheduler = new ScheduledExecutorScheduler("WebScannerScheduler", true, 1);
            this.server.addBean((Object)this.scannerScheduler);
        }
        if (this.scanner == null) {
            this.scanner = new Scanner((Scheduler)this.scannerScheduler, false);
            this.scanner.setScanInterval(this.scanPeriod);
            this.scanner.setReportDirs(false);
            this.scanner.setReportExistingFilesOnStartup(false);
            this.scanner.setScanDepth(1);
            this.scanner.addListener((Scanner.Listener)((Scanner.BulkListener)filenames -> {
                for (String filename : filenames) {
                    List<Runnable> tasks = this.scannerTasks.get(filename);
                    if (tasks == null) continue;
                    tasks.forEach(t -> t.run());
                }
            }));
            this.server.addBean((Object)this.scanner);
        }
        return this.scanner;
    }

    private void addScannerTask(File file, Runnable task) throws IOException {
        File parentFile = this.getParentStoreFile(file);
        String storeFilename = file.toPath().toRealPath(this.scannerLinkOptions).toString();
        List<Runnable> tasks = this.scannerTasks.get(storeFilename);
        if (tasks == null) {
            tasks = new ArrayList<Runnable>();
            this.scannerTasks.put(storeFilename, tasks);
        }
        tasks.add(task);
        this.getScanner().addDirectory(parentFile.toPath());
    }

    private void addStoreResourceScannerTask(String storeFilename, String storeType, SslContextFactory.Server sslFactory) throws IOException {
        if (storeFilename != null) {
            File storeFile = this.getStoreFile(storeFilename);
            this.addScannerTask(storeFile, () -> {
                try {
                    sslFactory.reload(f -> {});
                }
                catch (Exception e) {
                    logger.warn("Failed to reload the ssl factory related to {}", (Object)storeFile, (Object)e);
                }
            });
            if (PemConfigUtil.isPemConfigStoreType((String)storeType)) {
                String[] sources;
                try (FileInputStream pemConfigStream = new FileInputStream(storeFile);){
                    sources = PemConfigUtil.parseSources((InputStream)pemConfigStream);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Invalid PEM Config file: " + String.valueOf(e));
                }
                if (sources != null) {
                    for (String source : sources) {
                        this.addStoreResourceScannerTask(source, null, sslFactory);
                    }
                }
            }
        }
    }

    private RequestLog getRequestLog() {
        RequestLogWriter requestLogWriter = new RequestLogWriter();
        requestLogWriter.setFilename(this.webServerConfig.requestLog.filename);
        if (this.webServerConfig.requestLog.append != null) {
            requestLogWriter.setAppend(this.webServerConfig.requestLog.append.booleanValue());
        }
        if (this.webServerConfig.requestLog.filenameDateFormat != null) {
            requestLogWriter.setFilenameDateFormat(this.webServerConfig.requestLog.filenameDateFormat);
        }
        if (this.webServerConfig.requestLog.retainDays != null) {
            requestLogWriter.setRetainDays(this.webServerConfig.requestLog.retainDays.intValue());
        }
        CustomRequestLog requestLog = this.webServerConfig.requestLog.format != null ? new CustomRequestLog((RequestLog.Writer)requestLogWriter, this.webServerConfig.requestLog.format) : (this.webServerConfig.requestLog.extended != null && this.webServerConfig.requestLog.extended != false ? new CustomRequestLog((RequestLog.Writer)requestLogWriter, "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"") : new CustomRequestLog((RequestLog.Writer)requestLogWriter, "%{client}a - %u %t \"%r\" %s %O"));
        if (this.webServerConfig.requestLog.ignorePaths != null && !this.webServerConfig.requestLog.ignorePaths.isEmpty()) {
            String[] split = this.webServerConfig.requestLog.ignorePaths.split(",");
            String[] ignorePaths = new String[split.length];
            for (int i = 0; i < ignorePaths.length; ++i) {
                ignorePaths[i] = split[i].trim();
            }
            requestLog.setIgnorePaths(ignorePaths);
        }
        return requestLog;
    }

    public boolean isStarted() {
        return this.server != null && this.server.isStarted();
    }

    @Deprecated
    public int getPort() {
        return this.getPort(0);
    }

    public int getPort(int connectorIndex) {
        if (connectorIndex < this.connectors.length) {
            return this.connectors[connectorIndex].getLocalPort();
        }
        return -1;
    }

    protected WebAppContext createWebAppContext(String url, String warFile, Path warDirectory, String virtualHost) {
        WebAppContext webapp = new WebAppContext();
        if (url.startsWith("/")) {
            webapp.setContextPath(url);
        } else {
            webapp.setContextPath("/" + url);
        }
        webapp.addFilter(new FilterHolder(JolokiaFilter.class), "/*", EnumSet.of(DispatcherType.INCLUDE, DispatcherType.REQUEST));
        webapp.addFilter(new FilterHolder(AuthenticationFilter.class), "/auth/login/*", EnumSet.of(DispatcherType.REQUEST));
        webapp.setWar(warDirectory.resolve(warFile).toString());
        String baseTempDir = this.temporaryWarDir.toFile().getAbsolutePath();
        webapp.setAttribute("org.eclipse.jetty.webapp.basetempdir", (Object)baseTempDir);
        webapp.setTempDirectory(new File(baseTempDir + File.separator + warFile));
        webapp.getSecurityHandler().setAuthenticatorFactory((Authenticator.Factory)new DefaultAuthenticatorFactory());
        webapp.setVirtualHosts(new String[]{virtualHost});
        return webapp;
    }

    public void stop() throws Exception {
        this.stop(false);
    }

    public synchronized void stop(boolean isShutdown) throws Exception {
        if (isShutdown && this.isStarted()) {
            ActiveMQWebLogger.LOGGER.stoppingEmbeddedWebServer();
            this.server.stop();
            this.server = null;
            this.scanner = null;
            this.scannerScheduler = null;
            this.scannerTasks.clear();
            this.webContextData.clear();
            this.jolokiaUrls.clear();
            this.consoleUrls.clear();
            this.handlers = null;
            ActiveMQWebLogger.LOGGER.stoppedEmbeddedWebServer();
        }
    }

    public List<Pair<WebAppContext, String>> getWebContextData() {
        return this.webContextData;
    }

    public Server getWebServer() {
        return this.server;
    }
}

