/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.utils.PrefixUtil;

public class AddressInfo {
    private long id;
    private final SimpleString name;
    private boolean autoCreated = false;
    private static final EnumSet<RoutingType> EMPTY_ROUTING_TYPES = EnumSet.noneOf(RoutingType.class);
    private EnumSet<RoutingType> routingTypes;
    private RoutingType firstSeen;
    private boolean internal = false;
    private volatile long routedMessageCount = 0L;
    private static final AtomicLongFieldUpdater<AddressInfo> routedMessageCountUpdater = AtomicLongFieldUpdater.newUpdater(AddressInfo.class, "routedMessageCount");
    private volatile long unRoutedMessageCount = 0L;
    private static final AtomicLongFieldUpdater<AddressInfo> unRoutedMessageCountUpdater = AtomicLongFieldUpdater.newUpdater(AddressInfo.class, "unRoutedMessageCount");

    public AddressInfo(SimpleString name) {
        this(name, EnumSet.noneOf(RoutingType.class));
    }

    public AddressInfo(SimpleString name, EnumSet<RoutingType> routingTypes) {
        this.name = name;
        this.setRoutingTypes(routingTypes);
    }

    public AddressInfo(SimpleString name, RoutingType routingType) {
        this.name = name;
        this.addRoutingType(routingType);
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public AddressInfo setAutoCreated(boolean autoCreated) {
        this.autoCreated = autoCreated;
        return this;
    }

    public SimpleString getName() {
        return this.name;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public EnumSet<RoutingType> getRoutingTypes() {
        return this.routingTypes == null ? EMPTY_ROUTING_TYPES : this.routingTypes;
    }

    public AddressInfo setRoutingTypes(EnumSet<RoutingType> routingTypes) {
        this.routingTypes = routingTypes;
        this.firstSeen = routingTypes != null && !routingTypes.isEmpty() ? (RoutingType)routingTypes.iterator().next() : null;
        return this;
    }

    public AddressInfo addRoutingType(RoutingType routingType) {
        if (routingType != null) {
            if (this.routingTypes == null || this.routingTypes.isEmpty()) {
                this.routingTypes = EnumSet.of(routingType);
                this.firstSeen = routingType;
            } else {
                this.routingTypes.add(routingType);
            }
        }
        return this;
    }

    public RoutingType getRoutingType() {
        return this.firstSeen;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Address [name=" + this.name);
        buff.append(", id=" + this.id);
        buff.append(", routingTypes={");
        for (RoutingType routingType : this.getRoutingTypes()) {
            buff.append(routingType.toString() + ",");
        }
        if (buff.charAt(buff.length() - 1) == ',') {
            buff.deleteCharAt(buff.length() - 1);
        }
        buff.append("}");
        buff.append(", autoCreated=" + this.autoCreated);
        buff.append("]");
        return buff.toString();
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public AddressInfo create(SimpleString name, RoutingType routingType) {
        AddressInfo info = new AddressInfo(name, routingType);
        info.setInternal(this.internal);
        return info;
    }

    public AddressInfo getAddressAndRoutingType(Map<SimpleString, RoutingType> prefixes) {
        for (Map.Entry<SimpleString, RoutingType> entry : prefixes.entrySet()) {
            if (!this.getName().startsWith(entry.getKey())) continue;
            AddressInfo newAddressInfo = this.create(PrefixUtil.removePrefix((SimpleString)this.getName(), (SimpleString)entry.getKey()), entry.getValue());
            return newAddressInfo;
        }
        return this;
    }

    public long incrementRoutedMessageCount() {
        return routedMessageCountUpdater.incrementAndGet(this);
    }

    public long incrementUnRoutedMessageCount() {
        return unRoutedMessageCountUpdater.incrementAndGet(this);
    }

    public long getRoutedMessageCount() {
        return routedMessageCountUpdater.get(this);
    }

    public long getUnRoutedMessageCount() {
        return unRoutedMessageCountUpdater.get(this);
    }
}

