/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.cursor.PageIterator;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PageTransactionInfoImpl
implements PageTransactionInfo {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final AtomicIntegerFieldUpdater<PageTransactionInfoImpl> numberOfMessagesUpdater = AtomicIntegerFieldUpdater.newUpdater(PageTransactionInfoImpl.class, "numberOfMessages");
    private static final AtomicIntegerFieldUpdater<PageTransactionInfoImpl> numberOfPersistentMessagesUpdater = AtomicIntegerFieldUpdater.newUpdater(PageTransactionInfoImpl.class, "numberOfPersistentMessages");
    private long transactionID;
    private volatile long recordID = -1L;
    private volatile boolean committed = false;
    private volatile boolean useRedelivery = false;
    private volatile boolean rolledback = false;
    private volatile int numberOfMessages = 0;
    private volatile int numberOfPersistentMessages = 0;
    private List<LateDelivery> lateDeliveries;

    public PageTransactionInfoImpl(long transactionID) {
        this();
        this.transactionID = transactionID;
    }

    public PageTransactionInfoImpl() {
    }

    @Override
    public long getRecordID() {
        return this.recordID;
    }

    @Override
    public void setRecordID(long recordID) {
        this.recordID = recordID;
    }

    @Override
    public long getTransactionID() {
        return this.transactionID;
    }

    @Override
    public boolean onUpdate(int update, StorageManager storageManager, PagingManager pagingManager) {
        int afterUpdate = numberOfMessagesUpdater.addAndGet(this, -update);
        return this.internalCheckSize(storageManager, pagingManager, afterUpdate);
    }

    @Override
    public boolean checkSize(StorageManager storageManager, PagingManager pagingManager) {
        return this.internalCheckSize(storageManager, pagingManager, numberOfMessagesUpdater.get(this));
    }

    public boolean internalCheckSize(StorageManager storageManager, PagingManager pagingManager, int size) {
        if (size <= 0) {
            if (storageManager != null) {
                try {
                    storageManager.deletePageTransactional(this.recordID);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.pageTxDeleteError(this.recordID, e);
                }
            }
            if (pagingManager != null) {
                pagingManager.removeTransaction(this.transactionID);
            }
            return false;
        }
        return true;
    }

    @Override
    public void increment(int durableSize, int nonDurableSize) {
        numberOfPersistentMessagesUpdater.addAndGet(this, durableSize);
        numberOfMessagesUpdater.addAndGet(this, durableSize + nonDurableSize);
    }

    @Override
    public int getNumberOfMessages() {
        return numberOfMessagesUpdater.get(this);
    }

    public synchronized void decode(ActiveMQBuffer buffer) {
        this.transactionID = buffer.readLong();
        numberOfMessagesUpdater.set(this, buffer.readInt());
        numberOfPersistentMessagesUpdater.set(this, numberOfMessagesUpdater.get(this));
        this.committed = true;
    }

    public synchronized void encode(ActiveMQBuffer buffer) {
        buffer.writeLong(this.transactionID);
        buffer.writeInt(numberOfPersistentMessagesUpdater.get(this));
    }

    public synchronized int getEncodeSize() {
        return 12;
    }

    @Override
    public synchronized void commit() {
        if (this.lateDeliveries != null) {
            for (LateDelivery pos : this.lateDeliveries) {
                pos.getSubscription().redeliver(pos.getIterator(), pos.getPageReference());
            }
            this.lateDeliveries.clear();
        }
        this.committed = true;
        this.lateDeliveries = null;
    }

    @Override
    public void store(StorageManager storageManager, PagingManager pagingManager, Transaction tx) throws Exception {
        storageManager.storePageTransaction(tx.getID(), this);
    }

    @Override
    public void storeUpdate(StorageManager storageManager, PagingManager pagingManager, Transaction tx) throws Exception {
        this.internalUpdatePageManager(storageManager, pagingManager, tx, 1);
    }

    @Override
    public void reloadUpdate(StorageManager storageManager, PagingManager pagingManager, Transaction tx, int increment) throws Exception {
        UpdatePageTXOperation updt = this.internalUpdatePageManager(storageManager, pagingManager, tx, increment);
        updt.setStored();
    }

    protected UpdatePageTXOperation internalUpdatePageManager(StorageManager storageManager, PagingManager pagingManager, Transaction tx, int increment) {
        UpdatePageTXOperation pgtxUpdate = (UpdatePageTXOperation)tx.getProperty(4);
        if (pgtxUpdate == null) {
            pgtxUpdate = new UpdatePageTXOperation(storageManager, pagingManager);
            tx.putProperty(4, pgtxUpdate);
            tx.addOperation(pgtxUpdate);
        }
        tx.setContainsPersistent();
        pgtxUpdate.addUpdate(this, increment);
        return pgtxUpdate;
    }

    @Override
    public boolean isCommit() {
        return this.committed;
    }

    @Override
    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    @Override
    public boolean isRollback() {
        return this.rolledback;
    }

    @Override
    public synchronized void rollback() {
        this.rolledback = true;
        this.committed = false;
        if (this.lateDeliveries != null) {
            for (LateDelivery pos : this.lateDeliveries) {
                pos.getSubscription().lateDeliveryRollback(pos.getPageReference().getPagedMessage().newPositionObject());
                this.onUpdate(1, null, pos.getSubscription().getPagingStore().getPagingManager());
            }
            this.lateDeliveries = null;
        }
    }

    public String toString() {
        return "PageTransactionInfoImpl(transactionID=" + this.transactionID + ",id=" + this.recordID + ",numberOfMessages=" + this.numberOfMessages + ")";
    }

    @Override
    public synchronized boolean deliverAfterCommit(PageIterator iterator, PageSubscription cursor, PagedReference pagedReference) {
        logger.trace("deliver after commit on {}, pagedReference={}", (Object)cursor, (Object)pagedReference);
        if (this.committed && this.useRedelivery) {
            logger.trace("commit & useRedelivery on {}, pagedReference={}", (Object)cursor, (Object)pagedReference);
            cursor.addPendingDelivery(pagedReference.getPagedMessage());
            cursor.redeliver(iterator, pagedReference);
            return true;
        }
        if (this.committed) {
            logger.trace("committed on {}, position={}, ignoring position", (Object)cursor, (Object)pagedReference);
            return false;
        }
        if (this.rolledback) {
            logger.trace("rolled back, position ignored on {}, position={}", (Object)cursor, (Object)pagedReference);
            cursor.positionIgnored(pagedReference.getPagedMessage().newPositionObject());
            this.onUpdate(1, null, cursor.getPagingStore().getPagingManager());
            return true;
        }
        logger.trace("deliverAftercommit/else, marking useRedelivery on {}, position {}", (Object)cursor, (Object)pagedReference);
        this.useRedelivery = true;
        if (this.lateDeliveries == null) {
            this.lateDeliveries = new LinkedList<LateDelivery>();
        }
        cursor.addPendingDelivery(pagedReference.getPagedMessage());
        this.lateDeliveries.add(new LateDelivery(cursor, pagedReference, iterator));
        return true;
    }

    private static class UpdatePageTXOperation
    extends TransactionOperationAbstract {
        private final HashMap<PageTransactionInfo, AtomicInteger> countsToUpdate = new HashMap();
        private boolean stored = false;
        private final StorageManager storageManager;
        private final PagingManager pagingManager;

        private UpdatePageTXOperation(StorageManager storageManager, PagingManager pagingManager) {
            this.storageManager = storageManager;
            this.pagingManager = pagingManager;
        }

        public void setStored() {
            this.stored = true;
        }

        public void addUpdate(PageTransactionInfo info, int increment) {
            AtomicInteger counter = this.countsToUpdate.get(info);
            if (counter == null) {
                counter = new AtomicInteger(0);
                this.countsToUpdate.put(info, counter);
            }
            counter.addAndGet(increment);
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
            this.storeUpdates(tx);
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
            this.storeUpdates(tx);
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (Map.Entry<PageTransactionInfo, AtomicInteger> entry : this.countsToUpdate.entrySet()) {
                entry.getKey().onUpdate(entry.getValue().intValue(), this.storageManager, this.pagingManager);
            }
        }

        private void storeUpdates(Transaction tx) throws Exception {
            if (!this.stored) {
                this.stored = true;
                for (Map.Entry<PageTransactionInfo, AtomicInteger> entry : this.countsToUpdate.entrySet()) {
                    this.storageManager.updatePageTransaction(tx.getID(), entry.getKey(), entry.getValue().get());
                }
            }
        }
    }

    private static class LateDelivery {
        final PageSubscription subscription;
        final PagedReference pagedReference;
        final PageIterator iterator;

        private LateDelivery(PageSubscription subscription, PagedReference pagedReference, PageIterator iterator) {
            this.subscription = subscription;
            this.pagedReference = pagedReference;
            this.iterator = iterator;
        }

        public PageSubscription getSubscription() {
            return this.subscription;
        }

        public PagedReference getPageReference() {
            return this.pagedReference;
        }

        public PageIterator getIterator() {
            return this.iterator;
        }
    }
}

