/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import java.util.HashSet;
import java.util.List;
import org.apache.activemq.artemis.core.management.impl.view.ConnectionField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;

public class ConnectionFilterPredicate
extends ActiveMQFilterPredicate<RemotingConnection> {
    private ConnectionField f;
    private ActiveMQServer server;

    public ConnectionFilterPredicate(ActiveMQServer server) {
        this.server = server;
    }

    @Override
    public boolean test(RemotingConnection connection) {
        if (this.f == null) {
            return true;
        }
        switch (this.f) {
            case CONNECTION_ID: {
                return this.matches(connection.getID());
            }
            case CLIENT_ID: {
                return this.matches(connection.getClientID());
            }
            case USERS: {
                List<ServerSession> sessions = this.server.getSessions(connection.getID().toString());
                HashSet<String> users = new HashSet<String>();
                for (ServerSession session : sessions) {
                    String username = session.getUsername() == null ? "" : session.getUsername();
                    users.add(username);
                }
                return this.matchAny(users);
            }
            case PROTOCOL: {
                return this.matches(connection.getProtocolName());
            }
            case SESSION_COUNT: {
                return this.matches(this.server.getSessions(connection.getID().toString()).size());
            }
            case REMOTE_ADDRESS: {
                return this.matches(connection.getTransportConnection().getRemoteAddress());
            }
            case LOCAL_ADDRESS: {
                return this.matches(connection.getTransportConnection().getLocalAddress());
            }
            case SESSION_ID: {
                return this.matchAny(this.server.getSessions(connection.getID().toString()));
            }
            case CREATION_TIME: {
                return this.matches(connection.getCreationTime());
            }
            case IMPLEMENTATION: {
                return this.matches(connection.getClass().getSimpleName());
            }
        }
        return true;
    }

    @Override
    public void setField(String field) {
        if (field != null && !field.equals("")) {
            this.f = ConnectionField.valueOfName(field);
            if (this.f == null) {
                this.f = ConnectionField.valueOf(field);
            }
        }
    }
}

