/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.Objects;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreMasterPolicy;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.core.server.impl.LiveActivation;
import org.jboss.logging.Logger;

public final class SharedStoreLiveActivation
extends LiveActivation {
    private static final Logger logger = Logger.getLogger(SharedStoreLiveActivation.class);
    private SharedStoreMasterPolicy sharedStoreMasterPolicy;
    private ActiveMQServerImpl activeMQServer;
    private volatile FileLockNodeManager.LockListener activeLockListener;
    private volatile ActivateCallback nodeManagerActivateCallback;

    public SharedStoreLiveActivation(ActiveMQServerImpl server, SharedStoreMasterPolicy sharedStoreMasterPolicy) {
        this.activeMQServer = server;
        this.sharedStoreMasterPolicy = sharedStoreMasterPolicy;
    }

    @Override
    public void run() {
        try {
            ActiveMQServerLogger.LOGGER.awaitingLiveLock();
            this.activeMQServer.checkJournalDirectory();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("First part initialization on " + this));
            }
            if (!this.activeMQServer.initialisePart1(false)) {
                return;
            }
            if (this.activeMQServer.getNodeManager().isBackupLive()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("announcing backup to the former live" + this));
                }
                this.activeMQServer.getBackupManager().start();
                if (!this.sharedStoreMasterPolicy.isWaitForActivation()) {
                    this.activeMQServer.setState(ActiveMQServer.SERVER_STATE.STARTED);
                }
                this.activeMQServer.getBackupManager().announceBackup();
            }
            this.nodeManagerActivateCallback = this.activeMQServer.getNodeManager().startLiveNode();
            this.activeMQServer.registerActivateCallback(this.nodeManagerActivateCallback);
            this.addLockListener(this.activeMQServer, this.activeMQServer.getNodeManager());
            if (this.activeMQServer.getState() == ActiveMQServer.SERVER_STATE.STOPPED || this.activeMQServer.getState() == ActiveMQServer.SERVER_STATE.STOPPING) {
                return;
            }
            this.activeMQServer.initialisePart2(false);
            this.activeMQServer.completeActivation();
            ActiveMQServerLogger.LOGGER.serverIsLive();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.initializationError(e);
            this.activeMQServer.callActivationFailureListeners(e);
        }
    }

    private void addLockListener(final ActiveMQServerImpl activeMQServer, NodeManager nodeManager) {
        if (nodeManager instanceof FileLockNodeManager) {
            FileLockNodeManager fileNodeManager;
            FileLockNodeManager fileLockNodeManager = fileNodeManager = (FileLockNodeManager)nodeManager;
            Objects.requireNonNull(fileLockNodeManager);
            this.activeLockListener = new FileLockNodeManager.LockListener(fileLockNodeManager){

                @Override
                public void lostLock() {
                    SharedStoreLiveActivation.this.stopStartServerInSeperateThread(activeMQServer);
                }
            };
            fileNodeManager.registerLockListener(this.activeLockListener);
        }
    }

    private void stopStartServerInSeperateThread(final ActiveMQServerImpl activeMQServer) {
        try {
            Runnable startServerRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        activeMQServer.stop(true, false);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Failed to stop artemis server after loosing the lock", (Throwable)e);
                    }
                    try {
                        activeMQServer.start();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to start artemis server after recovering from loosing the lock", (Throwable)e);
                    }
                }
            };
            Thread startServer = new Thread(startServerRunnable);
            startServer.start();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        NodeManager nodeManagerInUse = this.activeMQServer.getNodeManager();
        if (nodeManagerInUse != null) {
            ActivateCallback activateCallback;
            FileLockNodeManager.LockListener closeLockListener = this.activeLockListener;
            if (closeLockListener != null) {
                closeLockListener.unregisterListener();
            }
            if ((activateCallback = this.nodeManagerActivateCallback) != null) {
                this.activeMQServer.unregisterActivateCallback(activateCallback);
            }
            if (this.sharedStoreMasterPolicy.isFailoverOnServerShutdown() || permanently) {
                nodeManagerInUse.crashLiveServer();
            } else {
                nodeManagerInUse.pauseLiveServer();
            }
        }
    }
}

