/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.DisconnectConsumerMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionProducerCreditsFailMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionProducerCreditsMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveContinuationMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveLargeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;

public final class CoreSessionCallback
implements SessionCallback {
    private final Channel channel;
    private ProtocolManager protocolManager;
    private final RemotingConnection connection;
    private String name;

    public CoreSessionCallback(String name, ProtocolManager protocolManager, Channel channel, RemotingConnection connection) {
        this.name = name;
        this.protocolManager = protocolManager;
        this.channel = channel;
        this.connection = connection;
    }

    @Override
    public boolean isWritable(ReadyListener callback) {
        return this.connection.isWritable(callback);
    }

    @Override
    public boolean updateDeliveryCountAfterCancel(ServerConsumer consumer, MessageReference ref, boolean failed) {
        return false;
    }

    @Override
    public int sendLargeMessage(MessageReference ref, ServerMessage message, ServerConsumer consumer, long bodySize, int deliveryCount) {
        SessionReceiveLargeMessage packet = new SessionReceiveLargeMessage(consumer.getID(), (MessageInternal)message, bodySize, deliveryCount);
        this.channel.send((Packet)packet);
        int size = packet.getPacketSize();
        return size;
    }

    @Override
    public int sendLargeMessageContinuation(ServerConsumer consumer, byte[] body, boolean continues, boolean requiresResponse) {
        SessionReceiveContinuationMessage packet = new SessionReceiveContinuationMessage(consumer.getID(), body, continues, requiresResponse);
        this.channel.send((Packet)packet);
        return packet.getPacketSize();
    }

    @Override
    public int sendMessage(MessageReference ref, ServerMessage message, ServerConsumer consumer, int deliveryCount) {
        SessionReceiveMessage packet = new SessionReceiveMessage(consumer.getID(), (MessageInternal)message, deliveryCount);
        int size = 0;
        if (this.channel.sendBatched((Packet)packet)) {
            size = packet.getPacketSize();
        }
        return size;
    }

    @Override
    public void sendProducerCreditsMessage(int credits, SimpleString address) {
        SessionProducerCreditsMessage packet = new SessionProducerCreditsMessage(credits, address);
        this.channel.send((Packet)packet);
    }

    @Override
    public void browserFinished(ServerConsumer consumer) {
    }

    @Override
    public void afterDelivery() throws Exception {
    }

    @Override
    public void sendProducerCreditsFailMessage(int credits, SimpleString address) {
        SessionProducerCreditsFailMessage packet = new SessionProducerCreditsFailMessage(credits, address);
        this.channel.send((Packet)packet);
    }

    @Override
    public void closed() {
        this.protocolManager.removeHandler(this.name);
    }

    @Override
    public void disconnect(ServerConsumer consumerId, String queueName) {
        if (this.channel.supports((byte)12)) {
            this.channel.send((Packet)new DisconnectConsumerMessage(consumerId.getID()));
        } else {
            ActiveMQServerLogger.LOGGER.warnDisconnectOldClient(queueName);
        }
    }

    @Override
    public boolean hasCredits(ServerConsumer consumer) {
        return true;
    }
}

