/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.jms.InvalidClientIDException;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireConnection;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireMessageConverter;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireProtocolManagerFactory;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConnectionContext;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQProducerBrokerExchange;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQSession;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyServerConnection;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.OpenWireFormatFactory;
import org.apache.activemq.state.ProducerState;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.InetAddressUtil;
import org.apache.activemq.util.LongSequenceGenerator;

public class OpenWireProtocolManager
implements ProtocolManager<Interceptor>,
ClusterTopologyListener {
    private static final List<String> websocketRegistryNames = Collections.EMPTY_LIST;
    private static final IdGenerator BROKER_ID_GENERATOR = new IdGenerator();
    private static final IdGenerator ID_GENERATOR = new IdGenerator();
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();
    private final ActiveMQServer server;
    private final OpenWireProtocolManagerFactory factory;
    private OpenWireFormatFactory wireFactory;
    private boolean prefixPacketSize = true;
    private BrokerId brokerId;
    protected final ProducerId advisoryProducerId = new ProducerId();
    private final CopyOnWriteArrayList<OpenWireConnection> connections = new CopyOnWriteArrayList();
    private final Map<String, AMQConnectionContext> clientIdSet = new HashMap<String, AMQConnectionContext>();
    private String brokerName;
    private final Map<String, TopologyMember> topologyMap = new ConcurrentHashMap<String, TopologyMember>();
    private final LinkedList<TopologyMember> members = new LinkedList();
    private final ScheduledExecutorService scheduledPool;
    private boolean rebalanceClusterClients = false;
    private boolean updateClusterClients = false;
    private boolean updateClusterClientsOnRemove = false;
    private long maxInactivityDuration = 30000L;
    private long maxInactivityDurationInitalDelay = 10000L;
    private boolean useKeepAlive = true;
    private final OpenWireMessageConverter internalConverter;
    private final Map<SimpleString, RoutingType> prefixes = new HashMap<SimpleString, RoutingType>();

    public OpenWireProtocolManager(OpenWireProtocolManagerFactory factory, ActiveMQServer server) {
        this.factory = factory;
        this.server = server;
        this.wireFactory = new OpenWireFormatFactory();
        this.wireFactory.setCacheEnabled(false);
        this.advisoryProducerId.setConnectionId(ID_GENERATOR.generateId());
        this.scheduledPool = server.getScheduledPool();
        this.internalConverter = new OpenWireMessageConverter(this.wireFactory.createWireFormat());
        ClusterManager clusterManager = this.server.getClusterManager();
        ClusterConnection cc = clusterManager.getDefaultConnection(null);
        if (cc != null) {
            cc.addClusterTopologyListener((ClusterTopologyListener)this);
        }
    }

    public void nodeUP(TopologyMember member, boolean last) {
        if (this.topologyMap.put(member.getNodeId(), member) == null) {
            this.updateClientClusterInfo();
        }
    }

    public void nodeDown(long eventUID, String nodeID) {
        if (this.topologyMap.remove(nodeID) != null) {
            this.updateClientClusterInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ConnectionInfo info, Throwable error) throws InvalidClientIDException {
        Map<String, AMQConnectionContext> map = this.clientIdSet;
        synchronized (map) {
            String clientId = info.getClientId();
            if (clientId != null) {
                AMQConnectionContext context = this.clientIdSet.get(clientId);
                if (context != null && context.decRefCount() == 0) {
                    context.getConnection().disconnect(error != null);
                    this.connections.remove((Object)context.getConnection());
                    this.clientIdSet.remove(clientId);
                }
            } else {
                throw new InvalidClientIDException("No clientID specified for connection disconnect request");
            }
        }
    }

    public ScheduledExecutorService getScheduledPool() {
        return this.scheduledPool;
    }

    public ActiveMQServer getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClientClusterInfo() {
        LinkedList<TopologyMember> linkedList = this.members;
        synchronized (linkedList) {
            this.members.clear();
            this.members.addAll(this.topologyMap.values());
        }
        for (OpenWireConnection c : this.connections) {
            ConnectionControl control = this.newConnectionControl();
            try {
                c.updateClient(control);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.warn((Object)e.getMessage(), (Throwable)e);
                c.sendException(e);
            }
        }
    }

    public boolean acceptsNoHandshake() {
        return false;
    }

    public ProtocolManagerFactory<Interceptor> getFactory() {
        return this.factory;
    }

    public void updateInterceptors(List<BaseInterceptor> incomingInterceptors, List<BaseInterceptor> outgoingInterceptors) {
    }

    public ConnectionEntry createConnectionEntry(Acceptor acceptorUsed, Connection connection) {
        OpenWireFormat wf = (OpenWireFormat)this.wireFactory.createWireFormat();
        OpenWireConnection owConn = new OpenWireConnection(connection, this.server, (Executor)this.server.getExecutorFactory().getExecutor(), this, wf);
        owConn.sendHandshake();
        ConnectionEntry entry = new ConnectionEntry((RemotingConnection)owConn, null, System.currentTimeMillis(), -1L);
        owConn.setConnectionEntry(entry);
        return entry;
    }

    public void removeHandler(String name) {
    }

    public void handleBuffer(RemotingConnection connection, ActiveMQBuffer buffer) {
    }

    public void addChannelHandlers(ChannelPipeline pipeline) {
        pipeline.addLast("packet-decipher", (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4));
    }

    public boolean isProtocol(byte[] array) {
        int remainingLen;
        if (array.length < 8) {
            throw new IllegalArgumentException("Protocol header length changed " + array.length);
        }
        int start = this.prefixPacketSize ? 4 : 0;
        int j = 0;
        if (array[start] != 1) {
            return false;
        }
        WireFormatInfo info = new WireFormatInfo();
        byte[] magic = info.getMagic();
        int useLen = (remainingLen = array.length - ++start) > magic.length ? magic.length : remainingLen;
        useLen += start;
        for (int i = start; i < useLen; ++i) {
            if (array[i] != magic[j]) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public void handshake(NettyServerConnection connection, ActiveMQBuffer buffer) {
    }

    public List<String> websocketSubprotocolIdentifiers() {
        return websocketRegistryNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addConnection(OpenWireConnection connection, ConnectionInfo info) throws Exception {
        String username = info.getUserName();
        String password = info.getPassword();
        try {
            this.validateUser(username, password, connection);
        }
        catch (ActiveMQSecurityException e) {
            SecurityException ex = new SecurityException("User name [" + username + "] or password is invalid.");
            ex.initCause(e);
            throw ex;
        }
        String clientId = info.getClientId();
        if (clientId == null) {
            throw new InvalidClientIDException("No clientID specified for connection request");
        }
        Map<String, AMQConnectionContext> map = this.clientIdSet;
        synchronized (map) {
            AMQConnectionContext context = this.clientIdSet.get(clientId);
            if (context != null) {
                if (!info.isFailoverReconnect()) throw new InvalidClientIDException("Broker: " + this.getBrokerName() + " - Client: " + clientId + " already connected from " + context.getConnection().getRemoteAddress());
                OpenWireConnection oldConnection = context.getConnection();
                oldConnection.disconnect(true);
                this.connections.remove((Object)oldConnection);
                connection.reconnect(context, info);
            } else {
                context = connection.initContext(info);
                this.clientIdSet.put(clientId, context);
            }
            this.connections.add(connection);
            ActiveMQTopic topic = AdvisorySupport.getConnectionAdvisoryTopic();
            ConnectionInfo copy = info.copy();
            copy.setPassword("");
            this.fireAdvisory(context, topic, (Command)copy);
            context.getConnection().addSessions(context.getConnectionState().getSessionIds());
            return;
        }
    }

    public void fireAdvisory(AMQConnectionContext context, ActiveMQTopic topic, Command copy) throws Exception {
        this.fireAdvisory(context, topic, copy, null, null);
    }

    public BrokerId getBrokerId() {
        if (this.brokerId == null) {
            this.brokerId = new BrokerId(BROKER_ID_GENERATOR.generateId());
        }
        return this.brokerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAdvisory(AMQConnectionContext context, ActiveMQTopic topic, Command command, ConsumerId targetConsumerId, String originalConnectionId) throws Exception {
        ActiveMQMessage advisoryMessage = new ActiveMQMessage();
        if (originalConnectionId == null) {
            originalConnectionId = context.getConnectionId().getValue();
        }
        advisoryMessage.setStringProperty(MessageUtil.CONNECTION_ID_PROPERTY_NAME.toString(), originalConnectionId);
        advisoryMessage.setStringProperty("originBrokerName", this.getBrokerName());
        String id = this.getBrokerId() != null ? this.getBrokerId().getValue() : "NOT_SET";
        advisoryMessage.setStringProperty("originBrokerId", id);
        String url = context.getConnection().getLocalAddress();
        advisoryMessage.setStringProperty("originBrokerURL", url);
        advisoryMessage.setDataStructure((DataStructure)command);
        advisoryMessage.setPersistent(false);
        advisoryMessage.setType("Advisory");
        advisoryMessage.setMessageId(new MessageId(this.advisoryProducerId, this.messageIdGenerator.getNextSequenceId()));
        advisoryMessage.setTargetConsumerId(targetConsumerId);
        advisoryMessage.setDestination((ActiveMQDestination)topic);
        advisoryMessage.setResponseRequired(false);
        advisoryMessage.setProducerId(this.advisoryProducerId);
        boolean originalFlowControl = context.isProducerFlowControl();
        AMQProducerBrokerExchange producerExchange = new AMQProducerBrokerExchange();
        producerExchange.setConnectionContext(context);
        producerExchange.setProducerState(new ProducerState(new ProducerInfo()));
        try {
            context.setProducerFlowControl(false);
            AMQSession sess = context.getConnection().getAdvisorySession();
            if (sess != null) {
                sess.send(producerExchange.getProducerState().getInfo(), (Message)advisoryMessage, false);
            }
        }
        finally {
            context.setProducerFlowControl(originalFlowControl);
        }
    }

    public String getBrokerName() {
        if (this.brokerName == null) {
            try {
                this.brokerName = InetAddressUtil.getLocalHostName().toLowerCase(Locale.ENGLISH);
            }
            catch (Exception e) {
                this.brokerName = this.server.getNodeID().toString();
            }
        }
        return this.brokerName;
    }

    protected ConnectionControl newConnectionControl() {
        ConnectionControl control = new ConnectionControl();
        String uri = this.generateMembersURI(this.rebalanceClusterClients);
        control.setConnectedBrokers(uri);
        control.setRebalanceConnection(this.rebalanceClusterClients);
        return control;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateMembersURI(boolean flip) {
        StringBuffer connectedBrokers = new StringBuffer();
        String separator = "";
        LinkedList<TopologyMember> linkedList = this.members;
        synchronized (linkedList) {
            if (this.members.size() > 0) {
                for (TopologyMember member : this.members) {
                    connectedBrokers.append(separator).append(member.toURI());
                    separator = ",";
                }
                if (flip && this.members.size() > 1) {
                    this.members.addLast(this.members.removeFirst());
                }
            }
        }
        String uri = connectedBrokers.toString();
        return uri;
    }

    public boolean isFaultTolerantConfiguration() {
        return false;
    }

    public void postProcessDispatch(MessageDispatch md) {
    }

    public boolean isStopped() {
        return false;
    }

    public void preProcessDispatch(MessageDispatch messageDispatch) {
    }

    public boolean isStopping() {
        return false;
    }

    public void validateUser(String login, String passcode, OpenWireConnection connection) throws Exception {
        this.server.getSecurityStore().authenticate(login, passcode, (RemotingConnection)connection);
    }

    public void sendBrokerInfo(OpenWireConnection connection) throws Exception {
        BrokerInfo brokerInfo = new BrokerInfo();
        brokerInfo.setBrokerName(this.getBrokerName());
        brokerInfo.setBrokerId(new BrokerId("" + this.server.getNodeID()));
        brokerInfo.setPeerBrokerInfos(null);
        brokerInfo.setFaultTolerantConfiguration(false);
        brokerInfo.setBrokerURL(connection.getLocalAddress());
        brokerInfo.setPeerBrokerInfos(null);
        connection.dispatch((Command)brokerInfo);
    }

    public void setUpInactivityParams(OpenWireConnection connection, WireFormatInfo command) throws IOException {
        long inactivityDurationToUse = command.getMaxInactivityDuration() > this.maxInactivityDuration ? this.maxInactivityDuration : command.getMaxInactivityDuration();
        long inactivityDurationInitialDelayToUse = command.getMaxInactivityDurationInitalDelay() > this.maxInactivityDurationInitalDelay ? this.maxInactivityDurationInitalDelay : command.getMaxInactivityDurationInitalDelay();
        boolean useKeepAliveToUse = this.maxInactivityDuration == 0L ? false : this.useKeepAlive;
        connection.setUpTtl(inactivityDurationToUse, inactivityDurationInitialDelayToUse, useKeepAliveToUse);
    }

    public void setRebalanceClusterClients(boolean rebalance) {
        this.rebalanceClusterClients = rebalance;
    }

    public boolean isRebalanceClusterClients() {
        return this.rebalanceClusterClients;
    }

    public void setUpdateClusterClients(boolean updateClusterClients) {
        this.updateClusterClients = updateClusterClients;
    }

    public boolean isUpdateClusterClients() {
        return this.updateClusterClients;
    }

    public void setUpdateClusterClientsOnRemove(boolean updateClusterClientsOnRemove) {
        this.updateClusterClientsOnRemove = updateClusterClientsOnRemove;
    }

    public boolean isUpdateClusterClientsOnRemove() {
        return this.updateClusterClientsOnRemove;
    }

    public void setBrokerName(String name) {
        this.brokerName = name;
    }

    public boolean isUseKeepAlive() {
        return this.useKeepAlive;
    }

    public void setUseKeepAlive(boolean useKeepAlive) {
        this.useKeepAlive = useKeepAlive;
    }

    public long getMaxInactivityDuration() {
        return this.maxInactivityDuration;
    }

    public void setMaxInactivityDuration(long maxInactivityDuration) {
        this.maxInactivityDuration = maxInactivityDuration;
    }

    public long getMaxInactivityDurationInitalDelay() {
        return this.maxInactivityDurationInitalDelay;
    }

    public void setMaxInactivityDurationInitalDelay(long maxInactivityDurationInitalDelay) {
        this.maxInactivityDurationInitalDelay = maxInactivityDurationInitalDelay;
    }

    public void setAnycastPrefix(String anycastPrefix) {
        for (String prefix : anycastPrefix.split(",")) {
            this.prefixes.put(SimpleString.toSimpleString((String)prefix), RoutingType.ANYCAST);
        }
    }

    public void setMulticastPrefix(String multicastPrefix) {
        for (String prefix : multicastPrefix.split(",")) {
            this.prefixes.put(SimpleString.toSimpleString((String)prefix), RoutingType.MULTICAST);
        }
    }

    public Map<SimpleString, RoutingType> getPrefixes() {
        return this.prefixes;
    }

    public List<DestinationInfo> getTemporaryDestinations() {
        ArrayList<DestinationInfo> total = new ArrayList<DestinationInfo>();
        for (OpenWireConnection connection : this.connections) {
            total.addAll(connection.getTemporaryDestinations());
        }
        return total;
    }

    public OpenWireMessageConverter getInternalConverter() {
        return this.internalConverter;
    }
}

