/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools;

import io.airlift.airline.Option;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.OptionalLocking;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryDatabase;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryNIO;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JDBCJournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.HierarchicalObjectRepository;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;

public class DBOption
extends OptionalLocking {
    protected JournalStorageManager storageManager;
    protected Configuration config;
    protected ExecutorService executor;
    protected ExecutorFactory executorFactory;
    protected ScheduledExecutorService scheduledExecutorService;
    @Option(name={"--output"}, description="Output name for the file")
    private String output;
    @Option(name={"--jdbc"}, description="It will activate jdbc")
    Boolean jdbc;
    @Option(name={"--jdbc-bindings-table-name"}, description="Name of the jdbc bindigns table")
    private String jdbcBindings = ActiveMQDefaultConfiguration.getDefaultBindingsTableName();
    @Option(name={"--jdbc-message-table-name"}, description="Name of the jdbc messages table")
    private String jdbcMessages = ActiveMQDefaultConfiguration.getDefaultLargeMessagesTableName();
    @Option(name={"--jdbc-large-message-table-name"}, description="Name of the large messages table")
    private String jdbcLargeMessages = ActiveMQDefaultConfiguration.getDefaultLargeMessagesTableName();
    @Option(name={"--jdbc-page-store-table-name"}, description="Name of the page store messages table")
    private String jdbcPageStore = ActiveMQDefaultConfiguration.getDefaultPageStoreTableName();
    @Option(name={"--jdbc-node-manager-table-name"}, description="Name of the jdbc node manager table")
    private String jdbcNodeManager = ActiveMQDefaultConfiguration.getDefaultNodeManagerStoreTableName();
    @Option(name={"--jdbc-connection-url"}, description="The connection used for the database")
    private String jdbcURL = null;
    @Option(name={"--jdbc-driver-class-name"}, description="JDBC driver classname")
    private String jdbcClassName = ActiveMQDefaultConfiguration.getDefaultDriverClassName();
    protected PagingManager pagingmanager;

    public boolean isJDBC() throws Exception {
        this.parseDBConfig();
        return this.jdbc;
    }

    public String getJdbcBindings() throws Exception {
        this.parseDBConfig();
        return this.jdbcBindings;
    }

    public DBOption setJdbcBindings(String jdbcBindings) {
        this.jdbcBindings = jdbcBindings;
        return this;
    }

    public String getJdbcMessages() throws Exception {
        this.parseDBConfig();
        return this.jdbcMessages;
    }

    public DBOption setJdbcMessages(String jdbcMessages) {
        this.jdbcMessages = jdbcMessages;
        return this;
    }

    public String getJdbcLargeMessages() throws Exception {
        this.parseDBConfig();
        return this.jdbcLargeMessages;
    }

    public DBOption setJdbcLargeMessages(String jdbcLargeMessages) {
        this.jdbcLargeMessages = jdbcLargeMessages;
        return this;
    }

    public String getJdbcPageStore() throws Exception {
        this.parseDBConfig();
        return this.jdbcPageStore;
    }

    public DBOption setJdbcPageStore(String jdbcPageStore) {
        this.jdbcPageStore = jdbcPageStore;
        return this;
    }

    public String getJdbcNodeManager() throws Exception {
        this.parseDBConfig();
        return this.jdbcNodeManager;
    }

    public DBOption setJdbcNodeManager(String jdbcNodeManager) {
        this.jdbcNodeManager = jdbcNodeManager;
        return this;
    }

    public String getJdbcURL() throws Exception {
        this.parseDBConfig();
        return this.jdbcURL;
    }

    public DBOption setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
        return this;
    }

    public String getJdbcClassName() throws Exception {
        this.parseDBConfig();
        return this.jdbcClassName;
    }

    public DBOption setJdbcClassName(String jdbcClassName) {
        this.jdbcClassName = jdbcClassName;
        return this;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        if (this.output != null) {
            PrintStream printStream;
            FileOutputStream fileOutputStream = new FileOutputStream(this.output);
            context.out = printStream = new PrintStream(fileOutputStream);
            Runtime.getRuntime().addShutdownHook(new Thread(printStream::close));
        }
        return null;
    }

    private void parseDBConfig() throws Exception {
        if (this.jdbc == null) {
            FileConfiguration fileConfiguration = this.getFileConfiguration();
            this.jdbc = fileConfiguration.isJDBC();
            if (this.jdbc.booleanValue()) {
                DatabaseStorageConfiguration storageConfiguration = (DatabaseStorageConfiguration)fileConfiguration.getStoreConfiguration();
                this.jdbcBindings = storageConfiguration.getBindingsTableName();
                this.jdbcMessages = storageConfiguration.getMessageTableName();
                this.jdbcLargeMessages = storageConfiguration.getLargeMessageTableName();
                this.jdbcPageStore = storageConfiguration.getPageStoreTableName();
                this.jdbcNodeManager = storageConfiguration.getNodeManagerStoreTableName();
                this.jdbcURL = storageConfiguration.getJdbcConnectionUrl();
                this.jdbcClassName = storageConfiguration.getJdbcDriverClassName();
            }
        }
    }

    public Configuration getParameterConfiguration() throws Exception {
        FileConfiguration configuration = this.readConfiguration();
        if (this.isJDBC()) {
            DatabaseStorageConfiguration storageConfiguration = new DatabaseStorageConfiguration();
            storageConfiguration.setJdbcConnectionUrl(this.getJdbcURL());
            storageConfiguration.setJdbcDriverClassName(this.getJdbcClassName());
            storageConfiguration.setBindingsTableName(this.getJdbcBindings());
            storageConfiguration.setMessageTableName(this.getJdbcMessages());
            storageConfiguration.setLargeMessageTableName(this.getJdbcLargeMessages());
            storageConfiguration.setPageStoreTableName(this.getJdbcPageStore());
            storageConfiguration.setNodeManagerStoreTableName(this.getJdbcNodeManager());
            configuration.setStoreConfiguration((StoreConfiguration)storageConfiguration);
        } else {
            configuration.setBindingsDirectory(this.getBinding());
            configuration.setJournalDirectory(this.getJournal());
            configuration.setPagingDirectory(this.getPaging());
            configuration.setLargeMessagesDirectory(this.getLargeMessages());
            configuration.setJournalType(JournalType.NIO);
        }
        return configuration;
    }

    protected void initializeJournal(Configuration configuration) throws Exception {
        this.config = configuration;
        this.executor = Executors.newFixedThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)this.getClass().getName()));
        this.executorFactory = new OrderedExecutorFactory((Executor)this.executor);
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(configuration.getScheduledThreadPoolMaxSize(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r);
            }
        });
        HierarchicalObjectRepository addressSettingsRepository = new HierarchicalObjectRepository(this.config.getWildcardConfiguration());
        addressSettingsRepository.setDefault((Object)new AddressSettings());
        if (configuration.isJDBC()) {
            this.storageManager = new JDBCJournalStorageManager(this.config, null, this.scheduledExecutorService, this.executorFactory, this.executorFactory, null);
            PagingStoreFactoryDatabase pageStoreFactory = new PagingStoreFactoryDatabase((DatabaseStorageConfiguration)configuration.getStoreConfiguration(), (StorageManager)this.storageManager, 1000L, this.scheduledExecutorService, this.executorFactory, this.executorFactory, false, null);
            this.pagingmanager = new PagingManagerImpl((PagingStoreFactory)pageStoreFactory, (HierarchicalRepository)addressSettingsRepository, configuration.getManagementAddress());
        } else {
            this.storageManager = new JournalStorageManager(this.config, (CriticalAnalyzer)EmptyCriticalAnalyzer.getInstance(), this.executorFactory, this.executorFactory);
            PagingStoreFactoryNIO pageStoreFactory = new PagingStoreFactoryNIO((StorageManager)this.storageManager, this.config.getPagingLocation(), 1000L, this.scheduledExecutorService, this.executorFactory, this.executorFactory, true, null);
            this.pagingmanager = new PagingManagerImpl((PagingStoreFactory)pageStoreFactory, (HierarchicalRepository)addressSettingsRepository, configuration.getManagementAddress());
        }
    }

    protected void cleanup() throws Exception {
        this.executor.shutdown();
        this.scheduledExecutorService.shutdown();
        this.storageManager.stop();
    }
}

