/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.logger;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInvalidFieldException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPSecurityException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class ActiveMQAMQPProtocolMessageBundle_impl
implements ActiveMQAMQPProtocolMessageBundle {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQAMQPProtocolMessageBundle_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public ActiveMQAMQPInternalErrorException errorCreatingTemporaryQueue(String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119001: error creating temporary queue, {}", (Object[])new Object[]{message}).getMessage();
        ActiveMQAMQPInternalErrorException objReturn_errorCreatingTemporaryQueue = new ActiveMQAMQPInternalErrorException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_errorCreatingTemporaryQueue));
        return objReturn_errorCreatingTemporaryQueue;
    }

    @Override
    public ActiveMQAMQPNotFoundException addressDoesntExist(String address) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119002: target address {} does not exist", (Object[])new Object[]{address}).getMessage();
        ActiveMQAMQPNotFoundException objReturn_addressDoesntExist = new ActiveMQAMQPNotFoundException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_addressDoesntExist));
        return objReturn_addressDoesntExist;
    }

    @Override
    public ActiveMQAMQPInternalErrorException errorCreatingConsumer(String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119005: error creating consumer, {}", (Object[])new Object[]{message}).getMessage();
        ActiveMQAMQPInternalErrorException objReturn_errorCreatingConsumer = new ActiveMQAMQPInternalErrorException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_errorCreatingConsumer));
        return objReturn_errorCreatingConsumer;
    }

    @Override
    public ActiveMQAMQPIllegalStateException errorStartingConsumer(String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119006: error starting consumer, {}", (Object[])new Object[]{message}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_errorStartingConsumer = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_errorStartingConsumer));
        return objReturn_errorStartingConsumer;
    }

    @Override
    public ActiveMQAMQPIllegalStateException errorAcknowledgingMessage(String messageID, String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119007: error acknowledging message {}, {}", (Object[])new Object[]{messageID, message}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_errorAcknowledgingMessage = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_errorAcknowledgingMessage));
        return objReturn_errorAcknowledgingMessage;
    }

    @Override
    public ActiveMQAMQPIllegalStateException errorCancellingMessage(String messageID, String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119008: error cancelling message {}, {}", (Object[])new Object[]{messageID, message}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_errorCancellingMessage = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_errorCancellingMessage));
        return objReturn_errorCancellingMessage;
    }

    @Override
    public ActiveMQAMQPNotFoundException sourceAddressDoesntExist() {
        String returnString = "AMQ119010: source address does not exist";
        ActiveMQAMQPNotFoundException objReturn_sourceAddressDoesntExist = new ActiveMQAMQPNotFoundException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_sourceAddressDoesntExist));
        return objReturn_sourceAddressDoesntExist;
    }

    @Override
    public ActiveMQAMQPInvalidFieldException sourceAddressNotSet() {
        String returnString = "AMQ119011: source address not set";
        ActiveMQAMQPInvalidFieldException objReturn_sourceAddressNotSet = new ActiveMQAMQPInvalidFieldException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_sourceAddressNotSet));
        return objReturn_sourceAddressNotSet;
    }

    @Override
    public ActiveMQAMQPIllegalStateException txNotFound(String xidToString) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119014: Transaction not found: xid={}", (Object[])new Object[]{xidToString}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_txNotFound = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_txNotFound));
        return objReturn_txNotFound;
    }

    @Override
    public ActiveMQAMQPSecurityException securityErrorCreatingConsumer(String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119015: not authorized to create consumer, {}", (Object[])new Object[]{message}).getMessage();
        ActiveMQAMQPSecurityException objReturn_securityErrorCreatingConsumer = new ActiveMQAMQPSecurityException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_securityErrorCreatingConsumer));
        return objReturn_securityErrorCreatingConsumer;
    }

    @Override
    public ActiveMQAMQPSecurityException securityErrorCreatingTempDestination(String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119016: not authorized to create temporary destination, {}", (Object[])new Object[]{message}).getMessage();
        ActiveMQAMQPSecurityException objReturn_securityErrorCreatingTempDestination = new ActiveMQAMQPSecurityException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_securityErrorCreatingTempDestination));
        return objReturn_securityErrorCreatingTempDestination;
    }

    @Override
    public ActiveMQAMQPSecurityException securityErrorCreatingProducer(String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119017: not authorized to create producer, {}", (Object[])new Object[]{message}).getMessage();
        ActiveMQAMQPSecurityException objReturn_securityErrorCreatingProducer = new ActiveMQAMQPSecurityException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_securityErrorCreatingProducer));
        return objReturn_securityErrorCreatingProducer;
    }

    @Override
    public ActiveMQAMQPIllegalStateException missingOfferedCapability(String capability) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119018: link is missing an offered capability declaration {}", (Object[])new Object[]{capability}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_missingOfferedCapability = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_missingOfferedCapability));
        return objReturn_missingOfferedCapability;
    }

    @Override
    public ActiveMQAMQPIllegalStateException missingBrokerID() {
        String returnString = "AMQ119019: There is no brokerID defined on the target connection. Connection will be closed.";
        ActiveMQAMQPIllegalStateException objReturn_missingBrokerID = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_missingBrokerID));
        return objReturn_missingBrokerID;
    }

    @Override
    public ActiveMQAMQPIllegalStateException brokerConnectionTimeout() {
        String returnString = "AMQ119020: The Broker Connection Open Callback Has Timed Out.";
        ActiveMQAMQPIllegalStateException objReturn_brokerConnectionTimeout = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_brokerConnectionTimeout));
        return objReturn_brokerConnectionTimeout;
    }

    @Override
    public ActiveMQAMQPIllegalStateException brokerConnectionRemoteLinkClosed() {
        String returnString = "AMQ119021: The broker connection had a remote link closed unexpectedly";
        ActiveMQAMQPIllegalStateException objReturn_brokerConnectionRemoteLinkClosed = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_brokerConnectionRemoteLinkClosed));
        return objReturn_brokerConnectionRemoteLinkClosed;
    }

    @Override
    public ActiveMQAMQPIllegalStateException brokerConnectionMirrorItself() {
        String returnString = "AMQ119022: The broker connection is trying to connect to itself. Check your configuration.";
        ActiveMQAMQPIllegalStateException objReturn_brokerConnectionMirrorItself = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_brokerConnectionMirrorItself));
        return objReturn_brokerConnectionMirrorItself;
    }

    @Override
    public ActiveMQAMQPIllegalStateException senderLinkRefused(String address) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119023: Sender link refused for address {}", (Object[])new Object[]{address}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_senderLinkRefused = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_senderLinkRefused));
        return objReturn_senderLinkRefused;
    }

    @Override
    public ActiveMQAMQPIllegalStateException missingDesiredCapability(String capability) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119024: link is missing a desired capability declaration {}", (Object[])new Object[]{capability}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_missingDesiredCapability = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_missingDesiredCapability));
        return objReturn_missingDesiredCapability;
    }

    @Override
    public ActiveMQAMQPIllegalStateException federationControlLinkRefused(String address) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119025: Federation control link refused: address = {}", (Object[])new Object[]{address}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_federationControlLinkRefused = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_federationControlLinkRefused));
        return objReturn_federationControlLinkRefused;
    }

    @Override
    public ActiveMQException malformedFederationControlMessage(String address) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119026: Malformed Federation control message: {}", (Object[])new Object[]{address}).getMessage();
        ActiveMQException objReturn_malformedFederationControlMessage = new ActiveMQException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_malformedFederationControlMessage);
        return objReturn_malformedFederationControlMessage;
    }

    @Override
    public ActiveMQException invalidAMQPConnectionState(Object state) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119027: Invalid AMQPConnection Remote State: {}", (Object[])new Object[]{state}).getMessage();
        ActiveMQException objReturn_invalidAMQPConnectionState = new ActiveMQException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidAMQPConnectionState);
        return objReturn_invalidAMQPConnectionState;
    }

    @Override
    public ActiveMQException malformedFederationEventMessage(String message) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119028: Malformed Federation event message: {}", (Object[])new Object[]{message}).getMessage();
        ActiveMQException objReturn_malformedFederationEventMessage = new ActiveMQException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_malformedFederationEventMessage);
        return objReturn_malformedFederationEventMessage;
    }

    @Override
    public ActiveMQAMQPIllegalStateException receiverLinkRefused(String address) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ119029: Receiver link refused for address {}", (Object[])new Object[]{address}).getMessage();
        ActiveMQAMQPIllegalStateException objReturn_receiverLinkRefused = new ActiveMQAMQPIllegalStateException(returnString);
        ActiveMQAMQPProtocolMessageBundle_impl._copyStackTraceMinusOne((Throwable)((Object)objReturn_receiverLinkRefused));
        return objReturn_receiverLinkRefused;
    }
}

