/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.Objects;
import java.util.UUID;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.protocol.amqp.federation.Federation;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromAddressPolicy;
import org.apache.activemq.artemis.utils.CompositeAddress;

public class AMQPFederationGenericConsumerInfo
implements FederationConsumerInfo {
    public static final String FEDERATED_QUEUE_PREFIX = "federated";
    public static final String QUEUE_NAME_FORMAT_STRING = "${address}::${routeType}";
    private final FederationConsumerInfo.Role role;
    private final String address;
    private final String queueName;
    private final RoutingType routingType;
    private final String filterString;
    private final String fqqn;
    private final int priority;
    private final String id;

    public AMQPFederationGenericConsumerInfo(FederationConsumerInfo.Role role, String address, String queueName, RoutingType routingType, String filterString, String fqqn, int priority) {
        this.role = role;
        this.address = address;
        this.queueName = queueName;
        this.routingType = routingType;
        this.filterString = filterString;
        this.fqqn = fqqn;
        this.priority = priority;
        this.id = UUID.randomUUID().toString();
    }

    public static AMQPFederationGenericConsumerInfo build(String address, String queueName, RoutingType routingType, String filterString, Federation federation, FederationReceiveFromAddressPolicy policy) {
        return new AMQPFederationGenericConsumerInfo(FederationConsumerInfo.Role.ADDRESS_CONSUMER, address, queueName, routingType, filterString, CompositeAddress.toFullyQualified((String)address, (String)queueName), ActiveMQDefaultConfiguration.getDefaultConsumerPriority());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public FederationConsumerInfo.Role getRole() {
        return this.role;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getFqqn() {
        return this.fqqn;
    }

    @Override
    public RoutingType getRoutingType() {
        return this.routingType;
    }

    @Override
    public String getFilterString() {
        return this.filterString;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AMQPFederationGenericConsumerInfo)) {
            return false;
        }
        AMQPFederationGenericConsumerInfo that = (AMQPFederationGenericConsumerInfo)o;
        return this.role == that.role && this.priority == that.priority && Objects.equals(this.address, that.address) && Objects.equals(this.queueName, that.queueName) && this.routingType == that.routingType && Objects.equals(this.filterString, that.filterString) && Objects.equals(this.fqqn, that.fqqn);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.role, this.address, this.queueName, this.routingType, this.filterString, this.fqqn, this.priority});
    }

    public String toString() {
        return "FederationConsumerInfo: { " + String.valueOf((Object)this.getRole()) + ", " + this.getFqqn() + "}";
    }
}

