/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.XPathExpression;
import org.apache.camel.spi.ExpressionResultTypeAware;

public final class ExpressionNodeHelper {
    private ExpressionNodeHelper() {
    }

    public static ExpressionDefinition toExpressionDefinition(Expression expression) {
        if (expression instanceof ExpressionResultTypeAware && expression.getClass().getName().equals("org.apache.camel.language.xpath.XPathBuilder")) {
            ExpressionResultTypeAware aware = (ExpressionResultTypeAware)expression;
            XPathExpression answer = new XPathExpression(expression);
            answer.setExpression(aware.getExpressionText());
            answer.setResultType(aware.getResultType());
            return answer;
        }
        if (expression instanceof ValueBuilder) {
            ValueBuilder builder = (ValueBuilder)expression;
            expression = builder.getExpression();
        }
        if (expression instanceof ExpressionDefinition) {
            ExpressionDefinition expressionDefinition = (ExpressionDefinition)expression;
            return expressionDefinition;
        }
        return new ExpressionDefinition(expression);
    }

    public static ExpressionDefinition toExpressionDefinition(Predicate predicate) {
        ValueBuilder builder;
        Expression expression;
        if (predicate instanceof ExpressionResultTypeAware && predicate.getClass().getName().equals("org.apache.camel.language.xpath.XPathBuilder")) {
            ExpressionResultTypeAware aware = (ExpressionResultTypeAware)predicate;
            Expression expression2 = (Expression)predicate;
            XPathExpression answer = new XPathExpression(expression2);
            answer.setExpression(aware.getExpressionText());
            answer.setResultType(aware.getResultType());
            return answer;
        }
        if (predicate instanceof ValueBuilder && (expression = (builder = (ValueBuilder)predicate).getExpression()) instanceof Predicate) {
            Predicate predicateExp;
            predicate = predicateExp = (Predicate)expression;
        }
        if (predicate instanceof ExpressionDefinition) {
            ExpressionDefinition expressionDefinition = (ExpressionDefinition)predicate;
            return expressionDefinition;
        }
        return new ExpressionDefinition(predicate);
    }
}

