/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.messenger.impl;

import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Received;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.messenger.Status;
import org.apache.qpid.proton.messenger.impl.Store;

class StoreEntry {
    private Store _store;
    private Integer _id;
    private String _address;
    private byte[] _encodedMsg;
    private int _encodedLength;
    private Delivery _delivery;
    private Status _status = Status.UNKNOWN;
    private Object _context;
    private boolean _inStore = false;

    public StoreEntry(Store store, String address) {
        this._store = store;
        this._address = address;
    }

    public Store getStore() {
        return this._store;
    }

    public boolean isStored() {
        return this._inStore;
    }

    public void stored() {
        this._inStore = true;
    }

    public void notStored() {
        this._inStore = false;
    }

    public String getAddress() {
        return this._address;
    }

    public byte[] getEncodedMsg() {
        return this._encodedMsg;
    }

    public int getEncodedLength() {
        return this._encodedLength;
    }

    public void setEncodedMsg(byte[] encodedMsg, int length) {
        this._encodedMsg = encodedMsg;
        this._encodedLength = length;
    }

    public void setId(int id) {
        this._id = new Integer(id);
    }

    public Integer getId() {
        return this._id;
    }

    public void setDelivery(Delivery d) {
        if (this._delivery != null) {
            this._delivery.setContext(null);
        }
        this._delivery = d;
        if (this._delivery != null) {
            this._delivery.setContext(this);
        }
        this.updated();
    }

    public Delivery getDelivery() {
        return this._delivery;
    }

    public Status getStatus() {
        return this._status;
    }

    public void setStatus(Status status) {
        this._status = status;
    }

    private static Status _disp2status(DeliveryState disp) {
        if (disp == null) {
            return Status.PENDING;
        }
        if (disp instanceof Received) {
            return Status.PENDING;
        }
        if (disp instanceof Accepted) {
            return Status.ACCEPTED;
        }
        if (disp instanceof Rejected) {
            return Status.REJECTED;
        }
        if (disp instanceof Released) {
            return Status.RELEASED;
        }
        if (disp instanceof Modified) {
            return Status.MODIFIED;
        }
        assert (false);
        return null;
    }

    public void updated() {
        if (this._delivery != null) {
            DeliveryState disp;
            this._status = this._delivery.getRemoteState() != null ? StoreEntry._disp2status(this._delivery.getRemoteState()) : (this._delivery.remotelySettled() ? ((disp = this._delivery.getLocalState()) == null ? Status.SETTLED : StoreEntry._disp2status(this._delivery.getLocalState())) : Status.PENDING);
        }
    }

    public void setContext(Object context) {
        this._context = context;
    }

    public Object getContext() {
        return this._context;
    }
}

