/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web.controller;

import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.web.BrokerFacade;
import org.apache.activemq.web.DestinationFacade;
import org.apache.activemq.web.WebClient;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class SendMessage
extends DestinationFacade
implements Controller {
    private String jmsText;
    private boolean jmsPersistent;
    private int jmsPriority;
    private int jmsTimeToLive = -1;
    private String jmsCorrelationID;
    private String jmsReplyTo;
    private String jmsType;
    private int jmsMessageCount = 1;
    private String jmsMessageCountHeader = "JMSXMessageNumber";
    private boolean redirectToBrowse;

    public SendMessage(BrokerFacade brokerFacade) {
        super(brokerFacade);
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebClient client = WebClient.getWebClient((HttpServletRequest)request);
        ActiveMQDestination dest = this.createDestination();
        this.sendMessages(request, client, dest);
        if (this.redirectToBrowse && this.isQueue()) {
            return new ModelAndView("redirect:browse.jsp?destination=" + this.getJMSDestination());
        }
        return this.redirectToBrowseView();
    }

    protected void sendMessages(HttpServletRequest request, WebClient client, ActiveMQDestination dest) throws JMSException {
        if (this.jmsMessageCount <= 1) {
            this.jmsMessageCount = 1;
        }
        for (int i = 0; i < this.jmsMessageCount; ++i) {
            Message message = this.createMessage(client, request);
            this.appendHeaders(message, request);
            if (this.jmsMessageCount > 1) {
                message.setIntProperty(this.jmsMessageCountHeader, i + 1);
            }
            client.send((Destination)dest, message, this.jmsPersistent, this.jmsPriority, (long)this.jmsTimeToLive);
        }
    }

    public String getJMSCorrelationID() {
        return this.jmsCorrelationID;
    }

    public void setJMSCorrelationID(String correlationID) {
        if (correlationID != null) {
            correlationID = correlationID.trim();
        }
        this.jmsCorrelationID = correlationID;
    }

    public String getJMSReplyTo() {
        return this.jmsReplyTo;
    }

    public void setJMSReplyTo(String replyTo) {
        if (replyTo != null) {
            replyTo = replyTo.trim();
        }
        this.jmsReplyTo = replyTo;
    }

    public String getJMSType() {
        return this.jmsType;
    }

    public void setJMSType(String type) {
        if (type != null) {
            type = type.trim();
        }
        this.jmsType = type;
    }

    public boolean isJMSPersistent() {
        return this.jmsPersistent;
    }

    public void setJMSPersistent(boolean persistent) {
        this.jmsPersistent = persistent;
    }

    public int getJMSPriority() {
        return this.jmsPriority;
    }

    public void setJMSPriority(int priority) {
        this.jmsPriority = priority;
    }

    public String getJMSText() {
        return this.jmsText;
    }

    public void setJMSText(String text) {
        this.jmsText = text;
    }

    public int getJMSTimeToLive() {
        return this.jmsTimeToLive;
    }

    public void setJMSTimeToLive(int timeToLive) {
        this.jmsTimeToLive = timeToLive;
    }

    public int getJMSMessageCount() {
        return this.jmsMessageCount;
    }

    public void setJMSMessageCount(int copies) {
        this.jmsMessageCount = copies;
    }

    public String getJMSMessageCountHeader() {
        return this.jmsMessageCountHeader;
    }

    public void setJMSMessageCountHeader(String messageCountHeader) {
        if (messageCountHeader != null) {
            messageCountHeader = messageCountHeader.trim();
        }
        this.jmsMessageCountHeader = messageCountHeader;
    }

    protected Message createMessage(WebClient client, HttpServletRequest request) throws JMSException {
        if (this.jmsText != null) {
            return client.getSession().createTextMessage(this.jmsText);
        }
        return client.getSession().createMessage();
    }

    protected void appendHeaders(Message message, HttpServletRequest request) throws JMSException {
        message.setJMSCorrelationID(this.jmsCorrelationID);
        if (this.jmsReplyTo != null && this.jmsReplyTo.trim().length() > 0) {
            message.setJMSReplyTo((Destination)ActiveMQDestination.createDestination((String)this.jmsReplyTo, (byte)1));
        }
        message.setJMSType(this.jmsType);
        Map map = request.getParameterMap();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String str;
                String name = (String)entry.getKey();
                if (name.equals("secret")) continue;
                Object value = entry.getValue();
                if (!this.isValidPropertyName(name)) continue;
                if (value instanceof String[]) {
                    String[] array = (String[])value;
                    value = array.length > 0 ? array[0] : null;
                }
                if (name.equals("AMQ_SCHEDULED_DELAY") || name.equals("AMQ_SCHEDULED_PERIOD")) {
                    if (value == null || (str = value.toString().trim()).length() <= 0) continue;
                    message.setLongProperty(name, Long.parseLong(str));
                    continue;
                }
                if (name.equals("AMQ_SCHEDULED_REPEAT")) {
                    if (value == null || (str = value.toString().trim()).length() <= 0) continue;
                    message.setIntProperty(name, Integer.parseInt(str));
                    continue;
                }
                if (name.equals("AMQ_SCHEDULED_CRON")) {
                    if (value == null || (str = value.toString().trim()).length() <= 0) continue;
                    message.setStringProperty(name, str);
                    continue;
                }
                if (value instanceof String) {
                    String text = value.toString().trim();
                    value = text.length() == 0 ? null : text;
                }
                if (value == null) continue;
                message.setObjectProperty(name, value);
            }
        }
    }

    protected boolean isValidPropertyName(String name) {
        return name.startsWith("JMSX") || !name.startsWith("JMS");
    }

    public String[] getSupportedHttpMethods() {
        return new String[]{"POST"};
    }
}

