/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import org.apache.activemq.util.StringArrayConverter;
import org.junit.Assert;
import org.junit.Test;

public class StringArrayConverterTest {
    @Test
    public void testConvertToStringArray() throws Exception {
        Assert.assertNull((Object)StringArrayConverter.convertToStringArray(null));
        Assert.assertNull((Object)StringArrayConverter.convertToStringArray((Object)""));
        String[] array = StringArrayConverter.convertToStringArray((Object)"foo");
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertEquals((Object)"foo", (Object)array[0]);
        array = StringArrayConverter.convertToStringArray((Object)"foo,bar");
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertEquals((Object)"foo", (Object)array[0]);
        Assert.assertEquals((Object)"bar", (Object)array[1]);
        array = StringArrayConverter.convertToStringArray((Object)"foo,bar,baz");
        Assert.assertEquals((long)3L, (long)array.length);
        Assert.assertEquals((Object)"foo", (Object)array[0]);
        Assert.assertEquals((Object)"bar", (Object)array[1]);
        Assert.assertEquals((Object)"baz", (Object)array[2]);
    }

    @Test
    public void testConvertToString() throws Exception {
        Assert.assertEquals(null, (Object)StringArrayConverter.convertToString(null));
        Assert.assertEquals(null, (Object)StringArrayConverter.convertToString((String[])new String[0]));
        Assert.assertEquals((Object)"", (Object)StringArrayConverter.convertToString((String[])new String[]{""}));
        Assert.assertEquals((Object)"foo", (Object)StringArrayConverter.convertToString((String[])new String[]{"foo"}));
        Assert.assertEquals((Object)"foo,bar", (Object)StringArrayConverter.convertToString((String[])new String[]{"foo", "bar"}));
        Assert.assertEquals((Object)"foo,bar,baz", (Object)StringArrayConverter.convertToString((String[])new String[]{"foo", "bar", "baz"}));
    }
}

