/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.usage.MemoryUsage;
import org.apache.activemq.usage.Usage;
import org.apache.activemq.usage.UsageListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemoryUsageTest {
    MemoryUsage underTest;
    ThreadPoolExecutor executor;

    @Test
    public final void testPercentUsageNeedsNoThread() {
        int activeThreadCount = Thread.activeCount();
        this.underTest.setLimit(10L);
        this.underTest.start();
        this.underTest.increaseUsage(1L);
        Assert.assertEquals((String)"usage is correct", (long)10L, (long)this.underTest.getPercentUsage());
        Assert.assertEquals((String)"no new thread created without listener or callback", (long)activeThreadCount, (long)Thread.activeCount());
    }

    @Test
    public final void testAddUsageListenerStartsThread() throws Exception {
        int activeThreadCount = Thread.activeCount();
        this.underTest = new MemoryUsage();
        this.underTest.setExecutor(this.executor);
        this.underTest.setLimit(10L);
        this.underTest.start();
        final CountDownLatch called = new CountDownLatch(1);
        final String[] listnerThreadNameHolder = new String[1];
        this.underTest.addUsageListener(new UsageListener(){

            public void onUsageChanged(Usage usage, int oldPercentUsage, int newPercentUsage) {
                called.countDown();
                listnerThreadNameHolder[0] = Thread.currentThread().toString();
            }
        });
        this.underTest.increaseUsage(1L);
        Assert.assertTrue((String)"listener was called", (boolean)called.await(30L, TimeUnit.SECONDS));
        Assert.assertTrue((String)"listener called from another thread", (!Thread.currentThread().toString().equals(listnerThreadNameHolder[0]) ? 1 : 0) != 0);
        Assert.assertEquals((String)"usage is correct", (long)10L, (long)this.underTest.getPercentUsage());
        Assert.assertEquals((String)"new thread created with listener", (long)(activeThreadCount + 1), (long)Thread.activeCount());
    }

    @Test
    public void testPercentOfJvmHeap() throws Exception {
        this.underTest.setPercentOfJvmHeap(50);
        Assert.assertEquals((String)"limit is half jvm limit", (long)Math.round((double)Runtime.getRuntime().maxMemory() / 2.0), (long)this.underTest.getLimit());
    }

    @Test
    public void testParentPortion() throws Exception {
        this.underTest.setLimit(1491035750L);
        MemoryUsage child = new MemoryUsage(this.underTest, "child", 1.0f);
        Assert.assertEquals((String)"limits are matched whole", (long)this.underTest.getLimit(), (long)child.getLimit());
        child.setUsagePortion(1.0f);
        Assert.assertEquals((String)"limits are still matched whole", (long)this.underTest.getLimit(), (long)child.getLimit());
    }

    @Test(timeout=2000L)
    public void testLimitedWaitFail() throws Exception {
        this.underTest.setLimit(10L);
        this.underTest.start();
        this.underTest.increaseUsage(11L);
        Assert.assertFalse((String)"did not get usage within limit", (boolean)this.underTest.waitForSpace(500L));
    }

    @Before
    public void setUp() throws Exception {
        this.underTest = new MemoryUsage();
        this.executor = new ThreadPoolExecutor(1, 10, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "Usage Async Task");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.underTest.setExecutor(this.executor);
    }

    @After
    public void tearDown() {
        Assert.assertNotNull((Object)this.underTest);
        this.underTest.stop();
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }
}

