/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.delete;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.iterators.user.GrepIterator;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.master.state.CurrentState;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletState;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CleanUp
extends MasterRepo {
    private static final Logger log = LoggerFactory.getLogger(CleanUp.class);
    private static final long serialVersionUID = 1L;
    private TableId tableId;
    private NamespaceId namespaceId;
    private long creationTime;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (System.currentTimeMillis() < this.creationTime) {
            this.creationTime = System.currentTimeMillis();
        }
    }

    public CleanUp(TableId tableId, NamespaceId namespaceId) {
        this.tableId = tableId;
        this.namespaceId = namespaceId;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public long isReady(long tid, Master master) throws Exception {
        if (!master.hasCycled(this.creationTime)) {
            return 50L;
        }
        boolean done = true;
        Range tableRange = new KeyExtent(this.tableId, null, null).toMetadataRange();
        Scanner scanner = master.getContext().createScanner(MetadataTable.NAME, Authorizations.EMPTY);
        MetaDataTableScanner.configureScanner((ScannerBase)scanner, (CurrentState)master);
        scanner.setRange(tableRange);
        for (Map.Entry entry : scanner) {
            TabletLocationState locationState = MetaDataTableScanner.createTabletLocationState((Key)((Key)entry.getKey()), (Value)((Value)entry.getValue()));
            TabletState state = locationState.getState(master.onlineTabletServers());
            if (state.equals((Object)TabletState.UNASSIGNED)) continue;
            log.debug("Still waiting for table to be deleted: " + this.tableId + " locationState: " + locationState);
            done = false;
            break;
        }
        if (!done) {
            return 50L;
        }
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master master) {
        master.clearMigrations(this.tableId);
        int refCount = 0;
        try {
            ServerContext client = master.getContext();
            try (BatchScanner bs = client.createBatchScanner(MetadataTable.NAME, Authorizations.EMPTY, 8);){
                Range allTables = MetadataSchema.TabletsSection.getRange();
                Range tableRange = MetadataSchema.TabletsSection.getRange((TableId)this.tableId);
                Range beforeTable = new Range(allTables.getStartKey(), true, tableRange.getStartKey(), false);
                Range afterTable = new Range(tableRange.getEndKey(), false, allTables.getEndKey(), true);
                bs.setRanges(Arrays.asList(beforeTable, afterTable));
                bs.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                IteratorSetting cfg = new IteratorSetting(40, "grep", GrepIterator.class);
                GrepIterator.setTerm((IteratorSetting)cfg, (String)("/" + this.tableId + "/"));
                bs.addScanIterator(cfg);
                for (Map.Entry entry : bs) {
                    if (!((Key)entry.getKey()).getColumnQualifier().toString().contains("/" + this.tableId + "/")) continue;
                    ++refCount;
                }
            }
        }
        catch (Exception e) {
            refCount = -1;
            log.error("Failed to scan " + MetadataTable.NAME + " looking for references to deleted table " + this.tableId, (Throwable)e);
        }
        try {
            MetadataTableUtil.deleteTable((TableId)this.tableId, (refCount != 0 ? 1 : 0) != 0, (ServerContext)master.getContext(), null);
        }
        catch (Exception e) {
            log.error("error deleting " + this.tableId + " from metadata table", (Throwable)e);
        }
        try {
            ProblemReports.getInstance((ServerContext)master.getContext()).deleteProblemReports(this.tableId);
        }
        catch (Exception e) {
            log.error("Failed to delete problem reports for table " + this.tableId, (Throwable)e);
        }
        if (refCount == 0) {
            try {
                VolumeManager fs = master.getFileSystem();
                for (String dir : ServerConstants.getTablesDirs((ServerContext)master.getContext())) {
                    fs.deleteRecursively(new Path(dir, this.tableId.canonical()));
                }
            }
            catch (IOException e) {
                log.error("Unable to remove deleted table directory", (Throwable)e);
            }
            catch (IllegalArgumentException exception) {
                if (exception.getCause() instanceof UnknownHostException) {
                    log.error("Unable to remove deleted table directory", (Throwable)exception);
                }
                throw exception;
            }
        }
        try {
            master.getTableManager().removeTable(this.tableId);
            Tables.clearCache((ClientContext)master.getContext());
        }
        catch (Exception e) {
            log.error("Failed to find table id in zookeeper", (Throwable)e);
        }
        try {
            AuditedSecurityOperation.getInstance((ServerContext)master.getContext()).deleteTable(master.getContext().rpcCreds(), this.tableId, this.namespaceId);
        }
        catch (ThriftSecurityException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
        }
        Utils.unreserveTable(master, this.tableId, tid, true);
        Utils.unreserveNamespace(master, this.namespaceId, tid, false);
        LoggerFactory.getLogger(CleanUp.class).debug("Deleted table " + this.tableId);
        return null;
    }

    @Override
    public void undo(long tid, Master environment) {
    }
}

